/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.truezip;

import de.schlichtherle.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.locks.LockManager;
import org.apache.servicemix.locks.impl.SimpleLockManager;
import org.apache.servicemix.truezip.TrueZipEndpointType;

public class TrueZipPollerEndpoint
extends PollingEndpoint
implements TrueZipEndpointType {
    private de.schlichtherle.io.File file;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean autoCreateDirectory = true;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private LockManager lockManager;

    public TrueZipPollerEndpoint() {
    }

    public TrueZipPollerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public TrueZipPollerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public void poll() throws Exception {
        this.pollFileOrDirectory(this.file);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.file == null) {
            throw new DeploymentException("You must specify a file property");
        }
        if (this.isAutoCreateDirectory() && !this.file.exists()) {
            this.file.mkdirs();
        }
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = new de.schlichtherle.io.File(file);
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void pollFileOrDirectory(de.schlichtherle.io.File fileOrDirectory) {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(de.schlichtherle.io.File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            this.logger.debug((Object)("Polling directory " + fileOrDirectory));
            de.schlichtherle.io.File[] files = (de.schlichtherle.io.File[])fileOrDirectory.listFiles(this.getFilter());
            for (int i = 0; i < files.length; ++i) {
                this.pollFileOrDirectory(files[i], this.isRecursive());
            }
        } else {
            this.logger.debug((Object)("Skipping directory " + fileOrDirectory));
        }
    }

    protected void pollFile(final de.schlichtherle.io.File aFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Scheduling file " + aFile + " for processing"));
        }
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String uri = TrueZipPollerEndpoint.this.file.toURI().relativize(aFile.toURI()).toString();
                Lock lock = TrueZipPollerEndpoint.this.lockManager.getLock(uri);
                if (lock.tryLock()) {
                    try {
                        TrueZipPollerEndpoint.this.processFileAndDelete(aFile);
                    }
                    finally {
                        try {
                            lock.unlock();
                        }
                        catch (Exception ex) {
                            TrueZipPollerEndpoint.this.logger.error((Object)ex);
                        }
                        TrueZipPollerEndpoint.this.lockManager.removeLock(uri);
                    }
                }
                if (TrueZipPollerEndpoint.this.logger.isDebugEnabled()) {
                    TrueZipPollerEndpoint.this.logger.debug((Object)("Unable to acquire lock on " + aFile));
                }
                TrueZipPollerEndpoint.this.lockManager.removeLock(uri);
            }
        });
    }

    protected void processFileAndDelete(de.schlichtherle.io.File aFile) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing file " + aFile));
            }
            if (aFile.exists()) {
                this.processFile(aFile);
                if (this.isDeleteFile() && !aFile.delete()) {
                    throw new IOException("Could not delete file " + aFile);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to process file: " + aFile + ". Reason: " + e), (Throwable)e);
        }
    }

    protected void processFile(de.schlichtherle.io.File aFile) throws Exception {
        String name = aFile.getCanonicalPath();
        BufferedInputStream in = new BufferedInputStream((InputStream)new FileInputStream((File)aFile));
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, (InputStream)in, name);
        this.sendSync((MessageExchange)exchange);
        ((InputStream)in).close();
    }

    public String getLocationURI() {
        return this.file.toURI().toString();
    }

    public void process(MessageExchange exchange) throws Exception {
    }
}

