/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.modes;

import de.schlichtherle.crypto.SeekableBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SICSeekableBlockCipher
implements SeekableBlockCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private final byte[] IV;
    private final byte[] counter;
    private long blockCounter;
    private final byte[] counterOut;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SICSeekableBlockCipher(BlockCipher c) {
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV ivParams = (ParametersWithIV)params;
            byte[] iv = ivParams.getIV();
            System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
            this.reset();
            this.cipher.init(true, ivParams.getParameters());
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        if (!$assertionsDisabled && this.blockSize != this.cipher.getBlockSize()) {
            throw new AssertionError();
        }
        return this.blockSize;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.updateCounter();
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        int i = this.blockSize;
        while (--i >= 0) {
            out[outOff + i] = (byte)(this.counterOut[i] ^ in[inOff + i]);
        }
        ++this.blockCounter;
        return this.blockSize;
    }

    private final void updateCounter() {
        long block = this.blockCounter;
        int i = this.blockSize;
        while (--i >= 0) {
            this.counter[i] = (byte)(block += (long)(this.IV[i] & 0xFF));
            block >>>= 8;
        }
    }

    public void setBlockCounter(long block) {
        this.blockCounter = block;
    }

    public long getBlockCounter() {
        return this.blockCounter;
    }

    public void reset() {
        this.blockCounter = 0L;
        this.cipher.reset();
    }

    static {
        $assertionsDisabled = !SICSeekableBlockCipher.class.desiredAssertionStatus();
    }
}

