/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip.raes;

import de.schlichtherle.crypto.io.raes.KeyManagerRaesParameters;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.io.archive.zip.JarDriver;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import javax.swing.UIManager;

public abstract class AbstractZip32RaesDriver
extends JarDriver {
    private final long authenticationTrigger;

    protected AbstractZip32RaesDriver() {
        this(Long.MAX_VALUE);
    }

    protected AbstractZip32RaesDriver(long authenticationTrigger) {
        this.authenticationTrigger = authenticationTrigger;
    }

    public final long getAuthenticationTrigger() {
        return this.authenticationTrigger;
    }

    public Icon getOpenIcon(Archive archive) {
        return UIManager.getIcon("FileView.directoryIcon");
    }

    public Icon getClosedIcon(Archive archive) {
        return UIManager.getIcon("FileView.directoryIcon");
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        RaesReadOnlyFile rrof;
        try {
            rrof = RaesReadOnlyFile.getInstance(rof, this.getRaesParameters(archive));
        }
        catch (RaesKeyException failure) {
            throw new TransientIOException(failure);
        }
        if (rof.length() <= this.getAuthenticationTrigger()) {
            rrof.authenticate();
        }
        return super.createInputArchive(archive, rrof);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream out, InputArchive source) throws IOException {
        RaesOutputStream ros;
        try {
            ros = RaesOutputStream.getInstance(out, this.getRaesParameters(archive));
        }
        catch (RaesKeyException failure) {
            throw new TransientIOException(failure);
        }
        return super.createOutputArchive(archive, ros, source);
    }

    public RaesParameters getRaesParameters(Archive archive) {
        return new KeyManagerRaesParameters(archive.getPath());
    }
}

