/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.swing.FilterFileView;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;

final class FileView
extends FilterFileView {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileView(javax.swing.filechooser.FileView delegate) {
        super(delegate);
    }

    public Icon getIcon(java.io.File file) {
        Icon icon = FileView.closedIcon(file);
        return icon != null ? icon : super.getIcon(file);
    }

    public String getTypeDescription(java.io.File file) {
        String typeDescription = FileView.typeDescription(file);
        return typeDescription != null ? typeDescription : super.getTypeDescription(file);
    }

    public Boolean isTraversable(java.io.File file) {
        Boolean traversable = FileView.traversable(file);
        return traversable != null ? traversable : super.isTraversable(file);
    }

    static Icon openIcon(java.io.File file) {
        return FileView.icon(file);
    }

    static Icon closedIcon(java.io.File file) {
        return FileView.icon(file);
    }

    private static Icon icon(java.io.File file) {
        if (!(file instanceof File)) {
            return null;
        }
        File smartFile = (File)file;
        if (FileView.isValidArchive(smartFile)) {
            return UIManager.getIcon("FileView.directoryIcon");
        }
        if (FileView.isEntryInValidArchive(smartFile)) {
            return smartFile.isDirectory() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
        }
        return null;
    }

    static String typeDescription(java.io.File file) {
        if (!(file instanceof File)) {
            return null;
        }
        File smartFile = (File)file;
        if (FileView.isValidArchive(smartFile)) {
            return resources.getString("archiveFile");
        }
        if (FileView.isEntryInValidArchive(smartFile)) {
            return smartFile.isDirectory() ? resources.getString("archiveDirectoryEntry") : resources.getString("archiveFileEntry");
        }
        return null;
    }

    private static boolean isValidArchive(File file) {
        return file.isArchive() && file.isDirectory() && !FileView.createNonArchiveFile(file).isDirectory();
    }

    private static File createNonArchiveFile(File file) {
        return ArchiveDetector.NULL.createFile(file.getParentFile(), file.getName());
    }

    private static boolean isEntryInValidArchive(File file) {
        if (!file.isEntry()) {
            return false;
        }
        java.io.File parent = file.getParentFile();
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError((Object)"An archive entry must always name a parent!");
        }
        return parent.isDirectory() && !ArchiveDetector.NULL.createFile(parent.getPath()).isDirectory();
    }

    static Boolean traversable(java.io.File file) {
        if (!(file instanceof File)) {
            return null;
        }
        File smartFile = (File)file;
        return smartFile.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        $assertionsDisabled = !FileView.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/swing/FileView".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
    }
}

