/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.util;

import java.io.IOException;
import java.io.OutputStream;

public class SynchronizedOutputStream
extends OutputStream {
    protected final Object lock;
    protected OutputStream out;

    public SynchronizedOutputStream(OutputStream out) {
        this(out, null);
    }

    public SynchronizedOutputStream(OutputStream out, Object lock) {
        this.out = out;
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(b, 0, b.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doFlush();
        }
    }

    protected void doFlush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        try {
            this.doFlush();
        }
        finally {
            this.out.close();
        }
    }
}

