/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.File;
import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.util.Paths;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.apache.tools.tar.TarConstants;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarUtils;

public class TarInputArchive
implements InputArchive,
TarConstants {
    private static final byte[] NULL_RECORD;
    private static final int CHECKSUM_OFFSET = 148;
    private final Map entries = new LinkedHashMap();
    private InputArchiveMetaData metaData;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarInputArchive(InputStream in) throws IOException {
        TarInputStream tin = TarInputArchive.createValidatedTarInputStream(in);
        try {
            org.apache.tools.tar.TarEntry tinEntry;
            while ((tinEntry = tin.getNextEntry()) != null) {
                TarEntry entry;
                String name = Paths.normalize(tinEntry.getName(), '/');
                if (tinEntry.isDirectory()) {
                    entry = new TarEntry(tinEntry);
                } else {
                    java.io.File tmp;
                    try {
                        entry = (TarEntry)this.entries.get(name);
                        tmp = entry != null ? entry.getFile() : File.createTempFile("tzp-tar", null);
                        try {
                            FileOutputStream out = new FileOutputStream(tmp);
                            try {
                                File.cat((InputStream)tin, out);
                            }
                            finally {
                                out.close();
                            }
                        }
                        catch (IOException ex) {
                            boolean ok = tmp.delete();
                            if (!$assertionsDisabled && !ok) {
                                throw new AssertionError();
                            }
                            throw ex;
                        }
                    }
                    catch (InputIOException ex) {
                        throw ex;
                    }
                    catch (IOException ex) {
                        throw new TransientIOException(new TempFileException(tinEntry, ex));
                    }
                    entry = new TarEntry(tinEntry, tmp);
                }
                entry.setName(name);
                this.entries.put(name, entry);
            }
        }
        catch (IOException failure) {
            this.close0();
            throw failure;
        }
    }

    private static TarInputStream createValidatedTarInputStream(InputStream in) throws IOException {
        byte[] buf = new byte[512];
        InputStream vin = TarInputArchive.readAhead(in, buf);
        if (!Arrays.equals(buf, NULL_RECORD)) {
            long expected = TarUtils.parseOctal((byte[])buf, (int)148, (int)8);
            for (int i = 0; i < 8; ++i) {
                buf[148 + i] = 32;
            }
            long is = TarUtils.computeCheckSum((byte[])buf);
            if (expected != is) {
                throw new IOException("Illegal initial record in TAR file: Expected checksum " + expected + ", is " + is + "!");
            }
        }
        return new TarInputStream(vin, 10240, 512);
    }

    static InputStream readAhead(InputStream in, byte[] buf) throws IOException {
        if (!(in instanceof InflaterInputStream) && in.markSupported()) {
            in.mark(buf.length);
            TarInputArchive.readFully(in, buf);
            in.reset();
            return in;
        }
        PushbackInputStream pin = new PushbackInputStream(in, buf.length);
        TarInputArchive.readFully(pin, buf);
        pin.unread(buf);
        return pin;
    }

    private static void readFully(InputStream in, byte[] buf) throws IOException {
        int r;
        int l = buf.length;
        int n = 0;
        do {
            if ((r = in.read(buf, n, l - n)) != -1) continue;
            throw new EOFException();
        } while ((n += r) < l);
    }

    public int getNumArchiveEntries() {
        return this.entries.size();
    }

    public Enumeration getArchiveEntries() {
        return Collections.enumeration(this.entries.values());
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        return (TarEntry)this.entries.get(entryName);
    }

    public InputStream getInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        return new FileInputStream(((TarEntry)entry).getFile());
    }

    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        Collection values = this.entries.values();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            TarEntry entry = (TarEntry)i.next();
            java.io.File file = entry.getFile();
            if (file == null) {
                if (!$assertionsDisabled && !entry.isDirectory()) {
                    throw new AssertionError();
                }
            } else {
                if (!$assertionsDisabled && !file.exists()) {
                    throw new AssertionError();
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            i.remove();
        }
    }

    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InputArchiveMetaData metaData) {
        this.metaData = metaData;
    }

    static {
        $assertionsDisabled = !TarInputArchive.class.desiredAssertionStatus();
        NULL_RECORD = new byte[512];
    }

    private static final class TempFileException
    extends FileNotFoundException {
        private TempFileException(org.apache.tools.tar.TarEntry entry, IOException cause) {
            super(entry.getName() + " (couldn't create temp file for archive entry)");
            this.initCause(cause);
        }
    }
}

