/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.io.archive.zip.Zip32OutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;

public class Zip32Driver
extends AbstractArchiveDriver {
    private static final long serialVersionUID = -7061546656075796996L;
    static final String TEMP_FILE_PREFIX = "tzp-zip";
    private final boolean preambled;
    private final boolean postambled;

    public Zip32Driver() {
        this("IBM437", false, false, null, null);
    }

    public Zip32Driver(String encoding) {
        this(encoding, false, false, null, null);
    }

    public Zip32Driver(String encoding, boolean preambled, boolean postambled, Icon openIcon, Icon closedIcon) {
        super(encoding, openIcon, closedIcon);
        this.preambled = preambled;
        this.postambled = postambled;
    }

    public boolean getPreambled() {
        return this.preambled;
    }

    public boolean getPostambled() {
        return this.postambled;
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String entryName, ArchiveEntry blueprint) throws CharConversionException {
        Zip32Entry entry;
        this.ensureEncodable(entryName);
        if (blueprint != null) {
            if (blueprint instanceof Zip32Entry) {
                entry = new Zip32Entry((Zip32Entry)blueprint);
                entry.setName(entryName);
            } else {
                entry = new Zip32Entry(entryName);
                entry.setTime(blueprint.getTime());
                entry.setSize(blueprint.getSize());
            }
        } else {
            entry = new Zip32Entry(entryName);
        }
        return entry;
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return this.createZip32InputArchive(archive, rof);
    }

    protected Zip32InputArchive createZip32InputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return new Zip32InputArchive(rof, this.getEncoding(), this.getPreambled(), this.getPostambled());
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream out, InputArchive source) throws IOException {
        return new MultiplexedOutputArchive(this.createZip32OutputArchive(archive, out, (Zip32InputArchive)source));
    }

    protected Zip32OutputArchive createZip32OutputArchive(Archive archive, OutputStream out, Zip32InputArchive source) throws IOException {
        return new Zip32OutputArchive(out, this.getEncoding(), source);
    }
}

