/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.File;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.util.JointEnumeration;
import de.schlichtherle.util.zip.BasicZipOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class Zip32OutputArchive
extends BasicZipOutputStream
implements OutputArchive {
    private final Zip32InputArchive source;
    private OutputArchiveMetaData metaData;
    private Zip32Entry tempEntry;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zip32OutputArchive(OutputStream out, String encoding, Zip32InputArchive source) throws NullPointerException, UnsupportedEncodingException, IOException {
        super(out, encoding);
        super.setLevel(9);
        this.source = source;
        if (source != null) {
            super.setComment(source.getComment());
            if (source.getPreambleLength() > 0L) {
                InputStream in = source.getPreambleInputStream();
                try {
                    File.cat(in, source.offsetsConsiderPreamble() ? this : out);
                }
                finally {
                    in.close();
                }
            }
        }
    }

    public int getNumArchiveEntries() {
        return this.size() + (this.tempEntry != null ? 1 : 0);
    }

    public Enumeration getArchiveEntries() {
        if (this.tempEntry == null) {
            return this.entries();
        }
        return new JointEnumeration(this.entries(), Collections.enumeration(Collections.singletonList(this.tempEntry)));
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        Zip32Entry e = (Zip32Entry)this.getEntry(entryName);
        if (e != null) {
            return e;
        }
        e = this.tempEntry;
        return e != null && entryName.equals(e.getName()) ? e : null;
    }

    public OutputStream getOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        if (this.isBusy()) {
            throw new OutputArchiveBusyException(entry);
        }
        Zip32Entry zipEntry = (Zip32Entry)entry;
        if (zipEntry.isDirectory()) {
            zipEntry.setMethod(0);
            zipEntry.setCrc(0L);
            zipEntry.setCompressedSize(0L);
            zipEntry.setSize(0L);
            return new EntryOutputStream(zipEntry);
        }
        if (srcEntry instanceof Zip32Entry) {
            Zip32Entry srcZipEntry = (Zip32Entry)srcEntry;
            zipEntry.setMethod(srcZipEntry.getMethod());
            zipEntry.setCrc(srcZipEntry.getCrc());
            zipEntry.setCompressedSize(srcZipEntry.getCompressedSize());
            zipEntry.setSize(srcZipEntry.getSize());
            if (!$assertionsDisabled && zipEntry.getMethod() == -1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && zipEntry.getCrc() == -1L) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && zipEntry.getCompressedSize() == -1L) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && zipEntry.getSize() == -1L) {
                throw new AssertionError();
            }
            return new EntryOutputStream(zipEntry, false);
        }
        if (srcEntry != null) {
            zipEntry.setSize(srcEntry.getSize());
        }
        switch (zipEntry.getMethod()) {
            case -1: {
                zipEntry.setMethod(8);
                break;
            }
            case 0: {
                if (zipEntry.getCrc() != -1L && zipEntry.getCompressedSize() != -1L && zipEntry.getSize() != -1L) break;
                if (!(srcEntry instanceof RfsEntry)) {
                    java.io.File temp = java.io.File.createTempFile("tzp-zip", null);
                    return new TempEntryOutputStream(zipEntry, temp);
                }
                java.io.File file = ((RfsEntry)srcEntry).getFile();
                long length = file.length();
                if (length > Integer.MAX_VALUE) {
                    throw new IOException("file too large");
                }
                FileInputStream in = new FileInputStream(file);
                Crc32OutputStream out = new Crc32OutputStream();
                File.cp(in, out);
                zipEntry.setCrc(out.crc.getValue());
                zipEntry.setCompressedSize(length);
                zipEntry.setSize(length);
                break;
            }
            case 8: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unsupported method");
                }
                break;
            }
        }
        return new EntryOutputStream(zipEntry);
    }

    public final boolean isBusy() {
        return super.isBusy() || this.tempEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntry(Zip32Entry entry, java.io.File temp) throws IOException {
        if (!$assertionsDisabled && entry.getMethod() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry.getCrc() == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry.getCompressedSize() == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry.getSize() == -1L) {
            throw new AssertionError();
        }
        try {
            FileInputStream in = new FileInputStream(temp);
            try {
                this.putNextEntry(entry);
                try {
                    File.cat(in, this);
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        finally {
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    public final void storeDirectory(ArchiveEntry entry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(entry, null).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        super.finish();
        if (this.source == null) {
            return;
        }
        long ipl = this.source.getPostambleLength();
        if (ipl <= 0L) {
            return;
        }
        long il = this.source.length();
        long ol = this.length();
        InputStream in = this.source.getPostambleInputStream();
        try {
            if (ol + ipl != il) {
                this.write(new byte[(int)(ol % 4L)]);
            }
            File.cat(in, this);
        }
        finally {
            in.close();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData metaData) {
        this.metaData = metaData;
    }

    static {
        $assertionsDisabled = !Zip32OutputArchive.class.desiredAssertionStatus();
    }

    private static class Crc32OutputStream
    extends OutputStream {
        private final CRC32 crc = new CRC32();

        private Crc32OutputStream() {
        }

        public void write(int b) {
            this.crc.update(b);
        }

        public void write(byte[] b, int off, int len) {
            this.crc.update(b, off, len);
        }
    }

    private class TempEntryOutputStream
    extends CheckedOutputStream {
        private final java.io.File temp;
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TempEntryOutputStream(Zip32Entry entry, java.io.File temp) throws IOException {
            super(new FileOutputStream(temp), new CRC32());
            if (!$assertionsDisabled && entry.getMethod() != 0) {
                throw new AssertionError();
            }
            this.temp = temp;
            Zip32OutputArchive.this.tempEntry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                finally {
                    long length = this.temp.length();
                    if (length > Integer.MAX_VALUE) {
                        throw new IOException("file too large");
                    }
                    Zip32OutputArchive.this.tempEntry.setCrc(this.getChecksum().getValue());
                    Zip32OutputArchive.this.tempEntry.setCompressedSize(length);
                    Zip32OutputArchive.this.tempEntry.setSize(length);
                    Zip32OutputArchive.this.storeTempEntry(Zip32OutputArchive.this.tempEntry, this.temp);
                }
            }
            finally {
                Zip32OutputArchive.this.tempEntry = null;
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$archive$zip$Zip32OutputArchive == null ? (class$de$schlichtherle$io$archive$zip$Zip32OutputArchive = Zip32OutputArchive.class$("de.schlichtherle.io.archive.zip.Zip32OutputArchive")) : class$de$schlichtherle$io$archive$zip$Zip32OutputArchive).desiredAssertionStatus();
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private EntryOutputStream(Zip32Entry entry) throws IOException {
            this(entry, true);
        }

        private EntryOutputStream(Zip32Entry entry, boolean deflate) throws IOException {
            super(Zip32OutputArchive.this);
            Zip32OutputArchive.this.putNextEntry(entry, deflate);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            Zip32OutputArchive.this.closeEntry();
        }
    }
}

