/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.servicemix.jbi.jaxp.SimpleNamespaceContext;

public class ExtendedXMLStreamReader
extends StreamReaderDelegate {
    private SimpleNamespaceContext context = new SimpleNamespaceContext();

    public ExtendedXMLStreamReader(XMLStreamReader delegate) {
        super(delegate);
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public int next() throws XMLStreamException {
        int next = super.next();
        if (next == 1) {
            this.context = new SimpleNamespaceContext(this.context, this.getNamespaces());
        } else if (next == 2) {
            this.context = this.context.getParent();
        }
        return next;
    }

    private Map getNamespaces() {
        HashMap<String, String> ns = new HashMap<String, String>();
        for (int i = 0; i < this.getNamespaceCount(); ++i) {
            ns.put(this.getNamespacePrefix(i), this.getNamespaceURI(i));
        }
        return ns;
    }
}

