/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck.mock;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.tck.mock.MockNormalizedMessage;

public class MockMessageExchange
implements MessageExchange {
    private ServiceEndpoint endpoint;
    private Exception error;
    private String exchangeId;
    private QName interfaceName;
    private QName operation;
    private URI pattern;
    private QName service;
    private MessageExchange.Role role;
    private ExchangeStatus status;
    private NormalizedMessage inMessage;
    private NormalizedMessage outMessage;
    private Fault fault;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public Fault getFault() {
        return this.fault;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public NormalizedMessage getInMessage() {
        return this.inMessage;
    }

    public void setInMessage(NormalizedMessage in) {
        this.inMessage = in;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public NormalizedMessage getOutMessage() {
        return this.outMessage;
    }

    public void setOutMessage(NormalizedMessage out) {
        this.outMessage = out;
    }

    public URI getPattern() {
        return this.pattern;
    }

    public void setPattern(URI pattern) {
        this.pattern = pattern;
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public void setRole(MessageExchange.Role role) {
        this.role = role;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExchangeStatus status) {
        this.status = status;
    }

    public Fault createFault() throws MessagingException {
        return new MockFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new MockNormalizedMessage();
    }

    public NormalizedMessage getMessage(String name) {
        if ("in".equalsIgnoreCase(name)) {
            return this.getInMessage();
        }
        if ("out".equalsIgnoreCase(name)) {
            return this.getOutMessage();
        }
        if ("fault".equalsIgnoreCase(name)) {
            return this.getFault();
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean isTransacted() {
        return false;
    }

    public void setMessage(NormalizedMessage msg, String name) throws MessagingException {
        if ("in".equalsIgnoreCase(name)) {
            this.setInMessage(msg);
        } else if ("out".equalsIgnoreCase(name)) {
            this.setOutMessage(msg);
        } else if ("fault".equalsIgnoreCase(name)) {
            this.setFault((Fault)msg);
        }
    }

    public void setProperty(String name, Object obj) {
        this.properties.put(name, obj);
    }

    public static class MockFault
    extends MockNormalizedMessage
    implements Fault {
    }
}

