/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.executors.impl;

public class ExecutorConfig {
    public static final int DEFAULT_CORE_POOL_SIZE = 4;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = -1;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 60000L;
    public static final boolean DEFAULT_THREAD_DAEMON = false;
    public static final int DEFAULT_THREAD_PRIORITY = 5;
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    public static final long DEFAULT_SHUTDOWN_DELAY = 1000L;
    public static final boolean DEFAULT_ALLOW_CORE_THREAD_TIMEOUT = true;
    public static final boolean DEFAULT_BYPASS_IF_SYNCHRONOUS = false;
    private ExecutorConfig parent;
    private Integer corePoolSize;
    private Integer maximumPoolSize;
    private Long keepAliveTime;
    private Boolean threadDaemon;
    private Integer threadPriority = 5;
    private Integer queueSize;
    private Long shutdownDelay;
    private Boolean allowCoreThreadsTimeout;
    private Boolean bypassIfSynchronous;

    public ExecutorConfig() {
        this(true, null);
    }

    public ExecutorConfig(boolean isDefaultConfig, ExecutorConfig parent) {
        this.parent = parent;
        if (isDefaultConfig) {
            this.setQueueSize(1024);
            this.setShutdownDelay(1000L);
            this.setThreadDaemon(false);
            this.setThreadPriority(5);
            this.setAllowCoreThreadsTimeout(true);
            this.setBypassIfSynchronous(false);
            this.setCorePoolSize(4);
            this.setKeepAliveTime(60000L);
            this.setMaximumPoolSize(-1);
        }
    }

    public int getCorePoolSize() {
        return this.getParent() != null && this.corePoolSize == null ? this.getParent().getCorePoolSize() : this.corePoolSize.intValue();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public long getKeepAliveTime() {
        return this.getParent() != null && this.keepAliveTime == null ? this.getParent().getKeepAliveTime() : this.keepAliveTime.longValue();
    }

    public void setKeepAliveTime(long keepAlive) {
        this.keepAliveTime = keepAlive;
    }

    public int getMaximumPoolSize() {
        return this.getParent() != null && this.maximumPoolSize == null ? this.getParent().getMaximumPoolSize() : this.maximumPoolSize.intValue();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getQueueSize() {
        return this.getParent() != null && this.queueSize == null ? this.getParent().getQueueSize() : this.queueSize.intValue();
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public boolean isThreadDaemon() {
        return this.getParent() != null && this.threadDaemon == null ? this.getParent().isThreadDaemon() : this.threadDaemon.booleanValue();
    }

    public void setThreadDaemon(boolean threadDaemon) {
        this.threadDaemon = threadDaemon;
    }

    public int getThreadPriority() {
        return this.getParent() != null && this.threadPriority == null ? this.getParent().getThreadPriority() : this.threadPriority.intValue();
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public long getShutdownDelay() {
        return this.getParent() != null && this.shutdownDelay == null ? this.getParent().getShutdownDelay() : this.shutdownDelay.longValue();
    }

    public void setShutdownDelay(long shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    public boolean isAllowCoreThreadsTimeout() {
        return this.getParent() != null && this.allowCoreThreadsTimeout == null ? this.getParent().isAllowCoreThreadsTimeout() : this.allowCoreThreadsTimeout.booleanValue();
    }

    public void setAllowCoreThreadsTimeout(boolean allowCoreThreadsTimeout) {
        this.allowCoreThreadsTimeout = allowCoreThreadsTimeout;
    }

    public boolean isBypassIfSynchronous() {
        return this.getParent() != null && this.bypassIfSynchronous == null ? this.getParent().isBypassIfSynchronous() : this.bypassIfSynchronous.booleanValue();
    }

    public void setBypassIfSynchronous(boolean bypassIfSynchronous) {
        this.bypassIfSynchronous = bypassIfSynchronous;
    }

    public ExecutorConfig getParent() {
        return this.parent;
    }

    public void setParent(ExecutorConfig parent) {
        this.parent = parent;
    }
}

