/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.hazelcast;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IdGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.servicemix.store.Entry;
import org.apache.servicemix.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastStore
implements Store,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastStore.class);
    private Map<String, Entry> datas;
    private HazelcastInstance hazelcastInstance;
    private IdGenerator idGenerator;
    private final long timeout;

    public HazelcastStore(String name) {
        this.hazelcastInstance = Hazelcast.newHazelcastInstance(null);
        this.idGenerator = this.hazelcastInstance.getIdGenerator(name);
        this.datas = this.hazelcastInstance.getMap(name);
        this.timeout = -1L;
    }

    public HazelcastStore(HazelcastInstance hazelcastInstance, String name) {
        this.hazelcastInstance = hazelcastInstance;
        this.idGenerator = hazelcastInstance.getIdGenerator(name);
        this.datas = hazelcastInstance.getMap(name);
        this.timeout = -1L;
    }

    public HazelcastStore(HazelcastInstance hazelcastInstance, String name, long timemout) {
        this.hazelcastInstance = hazelcastInstance;
        this.idGenerator = hazelcastInstance.getIdGenerator(name);
        this.datas = hazelcastInstance.getMap(name);
        this.timeout = timemout;
    }

    public boolean hasFeature(String feature) {
        return "Clustered".equals(feature);
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug("Storing object with id: " + id);
        this.datas.put(id, new Entry(data));
    }

    public String store(Object data) throws IOException {
        String id = String.valueOf(this.idGenerator.newId());
        this.store(id, data);
        return id;
    }

    public Object load(String id) throws IOException {
        Entry entry;
        LOG.debug("Loading/Removing object with id: " + id);
        if (this.timeout > 0L) {
            this.evict();
        }
        return (entry = this.datas.remove(id)) != null ? entry.getData() : null;
    }

    public Object peek(String id) throws IOException {
        LOG.debug("Peeking object with id: " + id);
        Entry entry = this.datas.get(id);
        return entry != null ? entry.getData() : null;
    }

    private void evict() {
        long now = System.currentTimeMillis();
        for (String key : this.datas.keySet()) {
            long age = now - this.datas.get(key).getTime();
            if (age <= this.timeout) continue;
            LOG.debug("Removing object with id " + key + " from store after " + age + " ms");
            this.datas.remove(key);
        }
    }
}

