/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.redis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreListener;
import org.apache.servicemix.store.base.BaseStoreFactory;
import org.apache.servicemix.store.redis.RedisStore;
import org.idevlab.rjc.RedisNode;

public class RedisStoreFactory
extends BaseStoreFactory {
    private Map<String, RedisStore> stores = new HashMap<String, RedisStore>();
    private RedisNode redisNode;
    private long timeout = -1L;
    public static final String STORE_PREFIX = "org.apache.servicemix.stores";

    public RedisStoreFactory(RedisNode redisNode) {
        this.redisNode = redisNode;
    }

    public synchronized Store open(String name) throws IOException {
        RedisStore store = this.stores.get(name);
        String storeName = "org.apache.servicemix.stores." + name;
        if (store == null) {
            store = this.timeout <= 0L ? new RedisStore(this.redisNode, storeName) : new RedisStore(this.redisNode, storeName, this.timeout);
            for (StoreListener listener : this.storeListeners) {
                store.addListener(listener);
            }
            this.stores.put(name, store);
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        this.stores.remove(store);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

