/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.memory;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.base.BaseStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
extends BaseStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryStore.class);
    private Map<String, Object> datas = new ConcurrentHashMap<String, Object>();
    private IdGenerator idGenerator;

    public MemoryStore(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean hasFeature(String name) {
        return false;
    }

    public void store(String id, Object data) throws IOException {
        LOG.debug("Storing object with id: " + id);
        this.datas.put(id, data);
        this.fireAddedEvent(id, data);
    }

    public String store(Object data) throws IOException {
        String id = this.idGenerator.generateId();
        this.store(id, data);
        return id;
    }

    public Object load(String id) throws IOException {
        LOG.debug("Loading/Removing object with id: " + id);
        Object data = this.datas.remove(id);
        this.fireEvictedEvent(id, data);
        return data;
    }

    public Object peek(String id) throws IOException {
        LOG.debug("Peeking object with id: " + id);
        return this.datas.get(id);
    }
}

