/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.vfs;

import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.vfs.FileObjectResolver;
import org.apache.servicemix.vfs.VFSEndpointType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFSSendingEndpoint
extends ProviderEndpoint
implements VFSEndpointType {
    private final Logger logger = LoggerFactory.getLogger(VFSSendingEndpoint.class);
    private FileObject file;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String path;
    private FileSystemManager fileSystemManager;

    protected void resolvePath() throws Exception {
        if (this.file == null) {
            this.file = FileObjectResolver.resolveToFileObject(this.getFileSystemManager(), this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        FileObject newFile;
        FileObject tmpFile;
        String name;
        String tmpName;
        block15: {
            this.resolvePath();
            OutputStream out = null;
            tmpName = null;
            name = null;
            tmpFile = null;
            newFile = null;
            FileContent content = null;
            try {
                name = this.marshaler.getOutputName(exchange, in);
                if (name == null) {
                    throw new MessagingException("No output name available. Cannot output message!");
                }
                tmpName = this.marshaler.getTempOutputName(exchange, in);
                this.file.close();
                if (tmpName != null) {
                    tmpFile = tmpName != null ? this.file.resolveFile(tmpName) : null;
                    tmpFile.close();
                    content = tmpFile.getContent();
                } else {
                    newFile = this.file.resolveFile(name);
                    newFile.close();
                    content = newFile.getContent();
                }
                content.close();
                if (content != null) {
                    out = content.getOutputStream();
                }
                if (out == null) {
                    throw new MessagingException("No output stream available for output name: " + name);
                }
                this.marshaler.writeMessage(exchange, in, out, name);
                Object var10_9 = null;
                if (out == null) break block15;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logger.error("Caught exception while closing stream on error: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                if (tmpName != null && name != null && !name.equals(tmpName)) {
                    if (!tmpFile.canRenameTo(newFile)) {
                        throw new IOException("File " + tmpName + " could not be renamed to " + name);
                    }
                    tmpFile.moveTo(newFile);
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException e) {
                this.logger.error("Caught exception while closing stream on error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (tmpName != null && name != null && !name.equals(tmpName)) {
            if (!tmpFile.canRenameTo(newFile)) {
                throw new IOException("File " + tmpName + " could not be renamed to " + name);
            }
            tmpFile.moveTo(newFile);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }
}

