/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.vfs;

import java.io.IOException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class FileObjectResolver {
    public static FileObject resolveToFileObject(FileSystemManager manager, String path) throws IllegalArgumentException, IOException {
        FileObject answer = null;
        try {
            if (manager == null) {
                manager = VFS.getManager();
            }
            if (path == null) {
                throw new IllegalArgumentException("You must specify a path property");
            }
            answer = manager.resolveFile(path);
            if (answer == null) {
                throw new IOException("Could not resolve file: " + path);
            }
            try {
                answer.createFolder();
            }
            catch (FileSystemException e) {
                throw FileObjectResolver.createIOException("Failed to create folder.", (Exception)((Object)e));
            }
        }
        catch (FileSystemException e) {
            throw FileObjectResolver.createIOException("Failed to initialize file system manager.", (Exception)((Object)e));
        }
        return answer;
    }

    private static IOException createIOException(String message, Exception cause) {
        IOException exception = new IOException(message);
        exception.initCause(cause);
        return exception;
    }
}

