/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanComponent
extends DefaultComponent {
    private static final Log LOG = LogFactory.getLog(BeanComponent.class);
    private ParameterMappingStrategy parameterMappingStrategy;

    public ProcessorEndpoint createEndpoint(Object bean) {
        String uri = "bean:generated:" + bean;
        return this.createEndpoint(bean, uri);
    }

    public ProcessorEndpoint createEndpoint(Object bean, String uri) {
        BeanProcessor processor = new BeanProcessor(bean, this.getCamelContext(), this.getParameterMappingStrategy());
        return this.createEndpoint(uri, processor);
    }

    public ParameterMappingStrategy getParameterMappingStrategy() {
        if (this.parameterMappingStrategy == null) {
            this.parameterMappingStrategy = this.createParameterMappingStrategy();
        }
        return this.parameterMappingStrategy;
    }

    public void setParameterMappingStrategy(ParameterMappingStrategy parameterMappingStrategy) {
        this.parameterMappingStrategy = parameterMappingStrategy;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        RegistryBean holder = new RegistryBean(this.getCamelContext(), remaining);
        BeanProcessor processor = ObjectConverter.toBool(parameters.remove("cache")) ? new BeanProcessor(holder.createCacheHolder()) : new BeanProcessor(holder);
        this.setProperties(processor, parameters);
        return this.createEndpoint(uri, processor);
    }

    protected ProcessorEndpoint createEndpoint(String uri, BeanProcessor processor) {
        ProcessorEndpoint answer = new ProcessorEndpoint(uri, this, (Processor)processor);
        answer.setExchangePattern(ExchangePattern.InOut);
        return answer;
    }

    protected ParameterMappingStrategy createParameterMappingStrategy() {
        return BeanInfo.createParameterMappingStrategy(this.getCamelContext());
    }
}

