/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.component;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jbi.management.DeploymentException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.wsn.component.WSNEndpoint;
import org.apache.servicemix.wsn.component.WSNPublisherEndpoint;
import org.apache.servicemix.wsn.component.WSNPullPointEndpoint;
import org.apache.servicemix.wsn.component.WSNServiceUnit;
import org.apache.servicemix.wsn.component.WSNSubscriptionEndpoint;
import org.oasis_open.docs.wsn.b_2.CreatePullPoint;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.brw_2.NotificationBroker;

public class WSNDeployer
extends AbstractDeployer
implements Deployer {
    protected FilenameFilter filter = new XmlFilter();
    protected JAXBContext context;

    public WSNDeployer(ServiceMixComponent component) {
        super(component);
        try {
            this.context = WSNEndpoint.createJAXBContext(NotificationBroker.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create jaxb context", e);
        }
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File[] xmls = new File(serviceUnitRootPath).listFiles(this.filter);
        return xmls != null && xmls.length > 0;
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        File[] xmls = new File(serviceUnitRootPath).listFiles(this.filter);
        if (xmls == null || xmls.length == 0) {
            throw this.failure("deploy", "No xml files found", null);
        }
        WSNServiceUnit su = new WSNServiceUnit();
        su.setComponent(this.component);
        su.setName(serviceUnitName);
        su.setRootPath(serviceUnitRootPath);
        for (int i = 0; i < xmls.length; ++i) {
            URL url;
            try {
                url = xmls[i].toURL();
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Error deploying xml file", (Throwable)e);
            }
            Endpoint ep = this.createEndpoint(url);
            ep.setServiceUnit((ServiceUnit)su);
            this.validate(ep);
            su.addEndpoint(ep);
        }
        if (su.getEndpoints().size() == 0) {
            throw this.failure("deploy", "Invalid wsdl: no endpoints found", null);
        }
        return su;
    }

    public Endpoint createEndpoint(URL url) throws DeploymentException {
        Object request = null;
        try {
            request = this.context.createUnmarshaller().unmarshal(url);
        }
        catch (JAXBException e) {
            throw this.failure("deploy", "Invalid xml", e);
        }
        return this.createEndpoint(request);
    }

    public Endpoint createEndpoint(Object request) throws DeploymentException {
        if (request instanceof Subscribe) {
            return new WSNSubscriptionEndpoint((Subscribe)request);
        }
        if (request instanceof CreatePullPoint) {
            return new WSNPullPointEndpoint((CreatePullPoint)request);
        }
        if (request instanceof RegisterPublisher) {
            return new WSNPublisherEndpoint((RegisterPublisher)request);
        }
        throw this.failure("deploy", "Unsupported request " + request.getClass().getName(), null);
    }

    public static class XmlFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

