/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet;

import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activeio.xnet.ServerService;
import org.apache.activeio.xnet.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicePool
implements ServerService {
    private static final Log log = LogFactory.getLog((Class)ServicePool.class);
    private final ServerService next;
    private final Executor executor;

    public ServicePool(ServerService next, final String name, int threads, long keepAliveTime) {
        this.next = next;
        ThreadPoolExecutor p = new ThreadPoolExecutor(threads, threads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        p.setThreadFactory(new ThreadFactory(){
            private volatile int id = 0;

            public Thread newThread(Runnable arg0) {
                Thread thread = new Thread(arg0, name + " " + this.getNextID());
                return thread;
            }

            private int getNextID() {
                return this.id++;
            }
        });
        this.executor = p;
    }

    public ServicePool(ServerService next, Executor executor) {
        this.next = next;
        this.executor = executor;
    }

    public void service(final Socket socket) throws ServiceException, IOException {
        final Runnable service = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ServicePool.this.next.service(socket);
                }
                catch (SecurityException e) {
                    log.error((Object)("Security error: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)"Unexpected error", e);
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable t) {
                        log.warn((Object)"Error while closing connection with client", t);
                    }
                }
            }
        };
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Runnable ctxCL = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(tccl);
                try {
                    service.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        };
        this.executor.execute(ctxCL);
    }

    public void init(Properties props) throws Exception {
        this.next.init(props);
    }

    public void start() throws ServiceException {
        this.next.start();
    }

    public void stop() throws ServiceException {
        this.next.stop();
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.next.getIP();
    }

    public int getPort() {
        return this.next.getPort();
    }
}

