/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConsumer
extends ScheduledPollConsumer<FileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FileConsumer.class);
    private FileEndpoint endpoint;
    private ConcurrentHashMap<File, File> filesBeingProcessed = new ConcurrentHashMap();
    private ConcurrentHashMap<File, Long> fileSizes = new ConcurrentHashMap(new LRUCache(1000));
    private ConcurrentHashMap<File, Long> noopMap = new ConcurrentHashMap(new LRUCache(1000));
    private long lastPollTime;
    private int unchangedDelay;
    private boolean unchangedSize;
    private boolean generateEmptyExchangeWhenIdle;
    private boolean alwaysConsume;
    private boolean recursive;
    private String regexPattern = "";
    private boolean exclusiveReadLock = true;

    public FileConsumer(FileEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected synchronized void poll() throws Exception {
        int rc = this.pollFileOrDirectory(this.endpoint.getFile(), true);
        if (rc == 0 && this.generateEmptyExchangeWhenIdle) {
            FileExchange exchange = this.endpoint.createExchange((File)null);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean sync) {
                }
            });
        }
        this.lastPollTime = System.currentTimeMillis();
    }

    protected int pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            return this.pollFile(fileOrDirectory);
        }
        if (processDir) {
            int rc = 0;
            if (this.isValidFile(fileOrDirectory)) {
                File[] files;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Polling directory " + fileOrDirectory));
                }
                for (File file : files = fileOrDirectory.listFiles()) {
                    rc += this.pollFileOrDirectory(file, this.isRecursive());
                }
            }
            return rc;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Skipping directory " + fileOrDirectory));
        }
        return 0;
    }

    protected int pollFile(File target) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Polling file: " + target));
        }
        if (!target.exists()) {
            return 0;
        }
        if (!this.isValidFile(target)) {
            return 0;
        }
        if (!this.endpoint.isNoop()) {
            if (this.filesBeingProcessed.contains(target)) {
                return 1;
            }
            this.filesBeingProcessed.put(target, target);
        }
        final FileProcessStrategy processStrategy = this.endpoint.getFileStrategy();
        final FileExchange exchange = this.endpoint.createExchange(target);
        this.endpoint.configureMessage(target, exchange.getIn());
        try {
            if (this.exclusiveReadLock) {
                this.acquireExclusiveReadLock(target);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("About to process file: " + target + " using exchange: " + exchange));
            }
            if (processStrategy.begin(this.endpoint, exchange, target)) {
                this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(boolean sync) {
                        File file = exchange.getFile();
                        boolean failed = exchange.isFailed();
                        boolean handled = DeadLetterChannel.isFailureHandled(exchange);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Done processing file: " + file + ". Status is: " + (failed ? "failed: " + failed + ", handled by failure processor: " + handled : "processed OK")));
                        }
                        boolean committed = false;
                        try {
                            if (!failed || handled) {
                                FileConsumer.this.processStrategyCommit(processStrategy, exchange, file, handled);
                                committed = true;
                            } else {
                                FileConsumer.this.handleException(exchange.getException());
                            }
                        }
                        finally {
                            if (!committed) {
                                FileConsumer.this.processStrategyRollback(processStrategy, exchange, file);
                            }
                            FileConsumer.this.filesBeingProcessed.remove(file);
                        }
                    }
                });
            } else {
                LOG.warn((Object)(this.endpoint + " can not process file: " + target));
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireExclusiveReadLock(File file) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Waiting for exclusive read lock to file: " + file));
        }
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        try {
            FileLock lock = channel.lock();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Acquired exclusive read lock: " + lock + " to file: " + file));
            }
            lock.release();
        }
        finally {
            ObjectHelper.close(channel, "FileConsumer during acquiring of exclusive read lock", LOG);
        }
    }

    protected void processStrategyCommit(FileProcessStrategy processStrategy, FileExchange exchange, File file, boolean failureHandled) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Committing file strategy: " + processStrategy + " for file: " + file + (failureHandled ? " that was handled by the failure processor." : "")));
            }
            processStrategy.commit(this.endpoint, exchange, file);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error committing file strategy: " + processStrategy), (Throwable)e);
            this.handleException(e);
        }
    }

    protected void processStrategyRollback(FileProcessStrategy processStrategy, FileExchange exchange, File file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rolling back file strategy: " + processStrategy + " for file: " + file));
        }
        processStrategy.rollback(this.endpoint, exchange, file);
    }

    protected boolean isValidFile(File file) {
        boolean result = false;
        if (file != null && file.exists() && this.isMatched(file) && (this.alwaysConsume || this.isChanged(file))) {
            result = true;
        }
        return result;
    }

    protected boolean isChanged(File file) {
        boolean answer;
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        boolean lastModifiedCheck = false;
        long modifiedDuration = 0L;
        if (this.getUnchangedDelay() > 0) {
            modifiedDuration = System.currentTimeMillis() - file.lastModified();
            lastModifiedCheck = modifiedDuration >= (long)this.getUnchangedDelay();
        }
        long fileModified = file.lastModified();
        Long previousModified = this.noopMap.get(file);
        this.noopMap.put(file, fileModified);
        if (previousModified == null || fileModified > previousModified) {
            lastModifiedCheck = true;
        }
        boolean sizeCheck = false;
        long sizeDifference = 0L;
        if (this.isUnchangedSize()) {
            Long value = this.fileSizes.get(file);
            sizeCheck = value == null ? true : file.length() != value.longValue();
        }
        boolean bl = answer = lastModifiedCheck || sizeCheck;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("file:" + file + " isChanged:" + answer + " " + "sizeCheck:" + sizeCheck + "(" + sizeDifference + ") " + "lastModifiedCheck:" + lastModifiedCheck + "(" + modifiedDuration + ")"));
        }
        if (this.isUnchangedSize()) {
            if (answer) {
                this.fileSizes.put(file, file.length());
            } else {
                this.fileSizes.remove(file);
            }
        }
        return answer;
    }

    protected boolean isMatched(File file) {
        String name = file.getName();
        if (name.startsWith(".")) {
            return false;
        }
        if (name.endsWith(".camelLock")) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (this.regexPattern != null && this.regexPattern.length() > 0 && !name.matches(this.regexPattern)) {
            return false;
        }
        if (this.endpoint.getExcludedNamePrefix() != null && name.startsWith(this.endpoint.getExcludedNamePrefix())) {
            return false;
        }
        String[] prefixes = this.endpoint.getExcludedNamePrefixes();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
        }
        if (this.endpoint.getExcludedNamePostfix() != null && name.endsWith(this.endpoint.getExcludedNamePostfix())) {
            return false;
        }
        String[] postfixes = this.endpoint.getExcludedNamePostfixes();
        if (postfixes != null) {
            for (String postfix : postfixes) {
                if (!name.endsWith(postfix)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public boolean isGenerateEmptyExchangeWhenIdle() {
        return this.generateEmptyExchangeWhenIdle;
    }

    public void setGenerateEmptyExchangeWhenIdle(boolean generateEmptyExchangeWhenIdle) {
        this.generateEmptyExchangeWhenIdle = generateEmptyExchangeWhenIdle;
    }

    public int getUnchangedDelay() {
        return this.unchangedDelay;
    }

    public void setUnchangedDelay(int unchangedDelay) {
        this.unchangedDelay = unchangedDelay;
    }

    public boolean isUnchangedSize() {
        return this.unchangedSize;
    }

    public void setUnchangedSize(boolean unchangedSize) {
        this.unchangedSize = unchangedSize;
    }

    public boolean isExclusiveReadLock() {
        return this.exclusiveReadLock;
    }

    public void setExclusiveReadLock(boolean exclusiveReadLock) {
        this.exclusiveReadLock = exclusiveReadLock;
    }

    public boolean isAlwaysConsume() {
        return this.alwaysConsume;
    }

    public void setAlwaysConsume(boolean alwaysConsume) {
        this.alwaysConsume = alwaysConsume;
    }

    public boolean isTimestamp() {
        return !this.alwaysConsume;
    }

    public void setTimestamp(boolean timestamp) {
        this.alwaysConsume = !timestamp;
    }
}

