/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.DataFormat;

public class ZipDataFormat
implements DataFormat {
    private static final int INITIALBYTEARRAYSIZE = 0x100000;
    private int compressionLevel;

    public ZipDataFormat() {
        this.compressionLevel = 1;
    }

    public ZipDataFormat(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        InputStream is;
        if (body instanceof InputStream) {
            InputStream inputStream = (InputStream)body;
        }
        if ((is = exchange.getIn().getBody(InputStream.class)) == null) {
            throw new IllegalArgumentException("Can't get the inputstream for ZipDataFormat mashalling");
        }
        DeflaterOutputStream zipOutput = new DeflaterOutputStream(stream, new Deflater(this.compressionLevel));
        IOConverter.copy(is, zipOutput);
        zipOutput.close();
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputStream is = stream;
        if (is == null) {
            exchange.getIn().getBody(InputStream.class);
        }
        if (is == null) {
            throw new IllegalArgumentException("Can't get the inputStream for ZipDataFormat unmashalling");
        }
        InflaterInputStream unzipInput = new InflaterInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOConverter.copy(unzipInput, bos);
        return bos.toByteArray();
    }
}

