/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class DefaultInstrumentationAgent
extends ServiceSupport
implements InstrumentationAgent {
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    public static final int DEFAULT_CONNECTION_PORT = -1;
    public static final String DEFAULT_SERVICE_URL_PATH = "/jmxrmi/camel";
    private static final transient Log LOG = LogFactory.getLog(DefaultInstrumentationAgent.class);
    private MBeanServer server;
    private Set<ObjectName> mbeans = new HashSet<ObjectName>();
    private MetadataMBeanInfoAssembler assembler;
    private JMXConnectorServer cs;
    private Integer registryPort;
    private Integer connectorPort;
    private String mBeanServerDefaultDomain;
    private String mBeanObjectDomainName;
    private String serviceUrlPath;
    private Boolean usePlatformMBeanServer = true;
    private Boolean createConnector;

    protected void finalizeSettings() {
        if (this.registryPort == null) {
            this.registryPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.registryPort", 1099);
        }
        if (this.connectorPort == null) {
            this.connectorPort = Integer.getInteger("org.apache.camel.jmx.rmiConnector.connectorPort", -1);
        }
        if (this.mBeanServerDefaultDomain == null) {
            this.mBeanServerDefaultDomain = System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain", DEFAULT_DOMAIN);
        }
        if (this.mBeanObjectDomainName == null) {
            this.mBeanObjectDomainName = System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName", DEFAULT_DOMAIN);
        }
        if (this.serviceUrlPath == null) {
            this.serviceUrlPath = System.getProperty("org.apache.camel.jmx.serviceUrlPath", DEFAULT_SERVICE_URL_PATH);
        }
        if (this.createConnector == null) {
            this.createConnector = Boolean.getBoolean("org.apache.camel.jmx.createRmiConnector");
        }
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null) {
            this.usePlatformMBeanServer = Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer");
        }
    }

    public void setRegistryPort(Integer value) {
        this.registryPort = value;
    }

    public void setConnectorPort(Integer value) {
        this.connectorPort = value;
    }

    public void setMBeanServerDefaultDomain(String value) {
        this.mBeanServerDefaultDomain = value;
    }

    public void setMBeanObjectDomainName(String value) {
        this.mBeanObjectDomainName = value;
    }

    public void setServiceUrlPath(String value) {
        this.serviceUrlPath = value;
    }

    public void setCreateConnector(Boolean flag) {
        this.createConnector = flag;
    }

    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanInfo mbi = null;
            mbi = this.assembler.getMBeanInfo(obj, name.toString());
            RequiredModelMBean mbean = (RequiredModelMBean)this.server.instantiate(RequiredModelMBean.class.getName());
            mbean.setModelMBeanInfo(mbi);
            try {
                mbean.setManagedResource(obj, "ObjectReference");
            }
            catch (InvalidTargetObjectTypeException itotex) {
                throw new JMException(itotex.getMessage());
            }
            this.registerMBeanWithServer(mbean, name, forceRegistration);
        }
    }

    public void unregister(ObjectName name) throws JMException {
        this.server.unregisterMBean(name);
    }

    protected void doStart() throws Exception {
        this.assembler = new MetadataMBeanInfoAssembler();
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
        if (this.server == null) {
            this.finalizeSettings();
            this.createMBeanServer();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting JMX agent on server: " + this.getMBeanServer()));
        }
    }

    protected void doStop() throws Exception {
        if (this.cs != null) {
            try {
                this.cs.stop();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.cs = null;
        }
        Object[] mBeans = this.mbeans.toArray();
        int caught = 0;
        for (Object name : mBeans) {
            this.mbeans.remove((ObjectName)name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                LOG.info((Object)"Exception unregistering MBean", (Throwable)jmex);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn((Object)("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation." + " See INFO log for details."));
        }
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        boolean exists = this.server.isRegistered(name);
        if (exists) {
            if (forceRegistration) {
                LOG.info((Object)"ForceRegistration enabled, unregistering existing MBean");
                this.server.unregisterMBean(name);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MBean already registered with objectname: " + name));
            }
        }
        ObjectInstance instance = null;
        if (forceRegistration || !exists) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Registering MBean with objectname: " + name));
            }
            instance = this.server.registerMBean(obj, name);
        }
        if (instance != null) {
            ObjectName registeredName = instance.getObjectName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registered MBean with objectname: " + registeredName));
            }
            this.mbeans.add(registeredName);
        }
    }

    protected void createMBeanServer() {
        String hostName = DEFAULT_HOST;
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                LOG.info((Object)"Cannot determine localhost name. Using default: 1099", (Throwable)uhe);
                hostName = DEFAULT_HOST;
            }
        } else {
            hostName = DEFAULT_HOST;
        }
        this.server = this.findOrCreateMBeanServer();
        try {
            if (this.createConnector.booleanValue()) {
                this.createJmxConnector(hostName);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Could not create and start JMX connector.", (Throwable)ioe);
        }
    }

    protected MBeanServer findOrCreateMBeanServer() {
        if (this.usePlatformMBeanServer.booleanValue()) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found MBeanServer with default domain " + server.getDefaultDomain()));
            }
            if (!this.mBeanServerDefaultDomain.equals(server.getDefaultDomain())) continue;
            return server;
        }
        return MBeanServerFactory.createMBeanServer(this.mBeanServerDefaultDomain);
    }

    protected void createJmxConnector(String host) throws IOException {
        try {
            LocateRegistry.createRegistry(this.registryPort);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created JMXConnector RMI regisry on port " + this.registryPort));
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        JMXServiceURL url = this.connectorPort > 0 ? new JMXServiceURL("service:jmx:rmi://" + host + ":" + this.connectorPort + "/jndi/rmi://" + host + ":" + this.registryPort + this.serviceUrlPath) : new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + this.registryPort + this.serviceUrlPath);
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
        Thread connectorThread = new Thread(){

            public void run() {
                try {
                    DefaultInstrumentationAgent.this.cs.start();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Could not start JMXConnector thread.", (Throwable)ioe);
                }
            }
        };
        connectorThread.setName("Camel JMX Connector Thread [" + url + "]");
        connectorThread.start();
        LOG.info((Object)("JMX Connector thread started and listening at: " + url));
    }

    public String getMBeanObjectDomainName() {
        return this.mBeanObjectDomainName;
    }

    public void setServer(MBeanServer value) {
        this.server = value;
    }
}

