/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAggregationCollection
extends AbstractCollection<Exchange>
implements AggregationCollection {
    private static final transient Log LOG = LogFactory.getLog(DefaultAggregationCollection.class);
    private Expression<Exchange> correlationExpression;
    private AggregationStrategy aggregationStrategy;
    private Map<Object, Exchange> map = new LinkedHashMap<Object, Exchange>();

    public DefaultAggregationCollection() {
    }

    public DefaultAggregationCollection(Expression<Exchange> correlationExpression, AggregationStrategy aggregationStrategy) {
        this.correlationExpression = correlationExpression;
        this.aggregationStrategy = aggregationStrategy;
    }

    protected Map<Object, Exchange> getMap() {
        return this.map;
    }

    @Override
    public boolean add(Exchange exchange) {
        Object correlationKey = this.correlationExpression.evaluate(exchange);
        Exchange oldExchange = this.map.get(correlationKey);
        Exchange newExchange = exchange;
        if (oldExchange != null) {
            Integer count = oldExchange.getProperty("org.apache.camel.Exchange.AggregatedCount", Integer.class);
            if (count == null) {
                count = 1;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            newExchange = this.aggregationStrategy.aggregate(oldExchange, newExchange);
            newExchange.setProperty("org.apache.camel.Exchange.AggregatedCount", count);
        }
        if (newExchange != oldExchange) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("put exchange:" + newExchange + " for key:" + correlationKey));
            }
            if (oldExchange == null) {
                newExchange.setProperty("org.apache.camel.Exchange.AggregatedCount", 1);
            }
            this.map.put(correlationKey, newExchange);
        }
        this.onAggregation(correlationKey, newExchange);
        return true;
    }

    @Override
    public Iterator<Exchange> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void onAggregation(Object correlationKey, Exchange newExchange) {
    }

    @Override
    public Expression<Exchange> getCorrelationExpression() {
        return this.correlationExpression;
    }

    @Override
    public void setCorrelationExpression(Expression<Exchange> correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    @Override
    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    @Override
    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

