/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.interceptor.DelayInterceptor;
import org.apache.camel.spi.InterceptStrategy;

public class Delayer
implements InterceptStrategy {
    private boolean enabled = true;
    private long delay;

    public Delayer() {
    }

    public Delayer(long delay) {
        this.delay = delay;
    }

    public static DelayInterceptor getDelayer(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)context;
            List<InterceptStrategy> list = defaultCamelContext.getInterceptStrategies();
            for (InterceptStrategy interceptStrategy : list) {
                if (!(interceptStrategy instanceof DelayInterceptor)) continue;
                return (DelayInterceptor)((Object)interceptStrategy);
            }
        }
        return null;
    }

    public Processor wrapProcessorInInterceptors(ProcessorType processorType, Processor target) throws Exception {
        DelayInterceptor delayer = new DelayInterceptor(processorType, target, this);
        return delayer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }
}

