/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.index;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BTreeVisitor<Key, Value> {
    public boolean isInterestedInKeysBetween(Key var1, Key var2);

    public void visit(List<Key> var1, List<Value> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LTEVisitor<Key extends Comparable<Key>, Value>
    implements BTreeVisitor<Key, Value> {
        private final Key value;

        public LTEVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return first == null || first.compareTo(this.value) <= 0;
        }

        @Override
        public void visit(List<Key> keys, List<Value> values) {
            for (int i = 0; i < keys.size(); ++i) {
                Comparable key = (Comparable)keys.get(i);
                if (key.compareTo(this.value) > 0) continue;
                this.matched(key, values.get(i));
            }
        }

        protected abstract void matched(Key var1, Value var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LTVisitor<Key extends Comparable<Key>, Value>
    implements BTreeVisitor<Key, Value> {
        private final Key value;

        public LTVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return first == null || first.compareTo(this.value) < 0;
        }

        @Override
        public void visit(List<Key> keys, List<Value> values) {
            for (int i = 0; i < keys.size(); ++i) {
                Comparable key = (Comparable)keys.get(i);
                if (key.compareTo(this.value) >= 0) continue;
                this.matched(key, values.get(i));
            }
        }

        protected abstract void matched(Key var1, Value var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GTEVisitor<Key extends Comparable<Key>, Value>
    implements BTreeVisitor<Key, Value> {
        private final Key value;

        public GTEVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return second == null || second.compareTo(this.value) >= 0;
        }

        @Override
        public void visit(List<Key> keys, List<Value> values) {
            for (int i = 0; i < keys.size(); ++i) {
                Comparable key = (Comparable)keys.get(i);
                if (key.compareTo(this.value) < 0) continue;
                this.matched(key, values.get(i));
            }
        }

        protected abstract void matched(Key var1, Value var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GTVisitor<Key extends Comparable<Key>, Value>
    implements BTreeVisitor<Key, Value> {
        private final Key value;

        public GTVisitor(Key value) {
            this.value = value;
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second) {
            return second == null || second.compareTo(this.value) > 0;
        }

        @Override
        public void visit(List<Key> keys, List<Value> values) {
            for (int i = 0; i < keys.size(); ++i) {
                Comparable key = (Comparable)keys.get(i);
                if (key.compareTo(this.value) <= 0) continue;
                this.matched(key, values.get(i));
            }
        }

        protected abstract void matched(Key var1, Value var2);
    }
}

