/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.DataFileAccessor;
import org.apache.kahadb.journal.DataFileAccessorPool;
import org.apache.kahadb.journal.DataFileAppender;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.journal.ReplicationTarget;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.DataByteArrayInputStream;
import org.apache.kahadb.util.LinkedNodeList;
import org.apache.kahadb.util.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Journal {
    private static final int MAX_BATCH_SIZE = 0x2000000;
    public static final int RECORD_HEAD_SPACE = 5;
    public static final byte USER_RECORD_TYPE = 1;
    public static final byte BATCH_CONTROL_RECORD_TYPE = 2;
    public static final byte[] BATCH_CONTROL_RECORD_MAGIC = Journal.bytes("WRITE BATCH");
    public static final int BATCH_CONTROL_RECORD_SIZE = 5 + BATCH_CONTROL_RECORD_MAGIC.length + 4 + 8;
    public static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_ARCHIVE_DIRECTORY = "data-archive";
    public static final String DEFAULT_FILE_PREFIX = "db-";
    public static final String DEFAULT_FILE_SUFFIX = ".log";
    public static final int DEFAULT_MAX_FILE_LENGTH = 0x2000000;
    public static final int DEFAULT_CLEANUP_INTERVAL = 30000;
    public static final int PREFERED_DIFF = 524288;
    private static final Log LOG = LogFactory.getLog(Journal.class);
    protected final Map<DataFileAppender.WriteKey, DataFileAppender.WriteCommand> inflightWrites = new ConcurrentHashMap<DataFileAppender.WriteKey, DataFileAppender.WriteCommand>();
    protected File directory = new File(".");
    protected File directoryArchive = new File("data-archive");
    protected String filePrefix = "db-";
    protected String fileSuffix = ".log";
    protected boolean started;
    protected int maxFileLength = 0x2000000;
    protected int preferedFileLength = 33030144;
    protected DataFileAppender appender;
    protected DataFileAccessorPool accessorPool;
    protected Map<Integer, DataFile> fileMap = new HashMap<Integer, DataFile>();
    protected Map<File, DataFile> fileByFileMap = new LinkedHashMap<File, DataFile>();
    protected LinkedNodeList<DataFile> dataFiles = new LinkedNodeList();
    protected final AtomicReference<Location> lastAppendLocation = new AtomicReference();
    protected Runnable cleanupTask;
    protected final AtomicLong totalLength = new AtomicLong();
    protected boolean archiveDataLogs;
    private ReplicationTarget replicationTarget;
    protected boolean checksum;

    public synchronized void start() throws IOException {
        Object l;
        if (this.started) {
            return;
        }
        long start = System.currentTimeMillis();
        this.accessorPool = new DataFileAccessorPool(this);
        this.started = true;
        this.preferedFileLength = Math.max(524288, this.getMaxFileLength() - 524288);
        this.appender = new DataFileAppender(this);
        File[] files = this.directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String n) {
                return dir.equals(Journal.this.directory) && n.startsWith(Journal.this.filePrefix) && n.endsWith(Journal.this.fileSuffix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String n = file.getName();
                    String numStr = n.substring(this.filePrefix.length(), n.length() - this.fileSuffix.length());
                    int num = Integer.parseInt(numStr);
                    DataFile dataFile = new DataFile(file, num, this.preferedFileLength);
                    this.fileMap.put(dataFile.getDataFileId(), dataFile);
                    this.totalLength.addAndGet(dataFile.getLength());
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            l = new ArrayList<DataFile>(this.fileMap.values());
            Collections.sort(l);
            Iterator i$ = l.iterator();
            while (i$.hasNext()) {
                DataFile df = (DataFile)i$.next();
                this.dataFiles.addLast(df);
                this.fileByFileMap.put(df.getFile(), df);
            }
        }
        this.getCurrentWriteFile();
        try {
            l = this.recoveryCheck(this.dataFiles.getTail());
            this.lastAppendLocation.set((Location)l);
        }
        catch (IOException e) {
            LOG.warn((Object)"recovery check failed", (Throwable)e);
        }
        this.cleanupTask = new Runnable(){

            public void run() {
                Journal.this.cleanup();
            }
        };
        Scheduler.executePeriodically(this.cleanupTask, 30000L);
        long end = System.currentTimeMillis();
        LOG.trace((Object)("Startup took: " + (end - start) + " ms"));
    }

    private static byte[] bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Location recoveryCheck(DataFile dataFile) throws IOException {
        byte[] controlRecord = new byte[BATCH_CONTROL_RECORD_SIZE];
        DataByteArrayInputStream controlIs = new DataByteArrayInputStream(controlRecord);
        Location location = new Location();
        location.setDataFileId(dataFile.getDataFileId());
        location.setOffset(0);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            while (true) {
                reader.read(location.getOffset(), controlRecord);
                controlIs.restart();
                if (controlIs.readInt() != BATCH_CONTROL_RECORD_SIZE) {
                    break;
                }
                if (controlIs.readByte() != 2) {
                    break;
                }
                for (int i = 0; i < BATCH_CONTROL_RECORD_MAGIC.length && controlIs.readByte() == BATCH_CONTROL_RECORD_MAGIC[i]; ++i) {
                }
                int size = controlIs.readInt();
                if (size > 0x2000000) {
                    break;
                }
                if (this.isChecksum()) {
                    long expectedChecksum = controlIs.readLong();
                    byte[] data = new byte[size];
                    reader.read(location.getOffset() + BATCH_CONTROL_RECORD_SIZE, data);
                    Adler32 checksum = new Adler32();
                    checksum.update(data, 0, data.length);
                    if (expectedChecksum != checksum.getValue()) {
                        break;
                    }
                }
                location.setOffset(location.getOffset() + BATCH_CONTROL_RECORD_SIZE + size);
            }
        }
        catch (IOException e) {
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        dataFile.setLength(location.getOffset());
        return location;
    }

    void addToTotalLength(int size) {
        this.totalLength.addAndGet(size);
    }

    synchronized DataFile getCurrentWriteFile() throws IOException {
        if (this.dataFiles.isEmpty()) {
            this.rotateWriteFile();
        }
        return this.dataFiles.getTail();
    }

    synchronized DataFile rotateWriteFile() {
        int nextNum = !this.dataFiles.isEmpty() ? this.dataFiles.getTail().getDataFileId() + 1 : 1;
        File file = this.getFile(nextNum);
        DataFile nextWriteFile = new DataFile(file, nextNum, this.preferedFileLength);
        this.fileMap.put(nextWriteFile.getDataFileId(), nextWriteFile);
        this.fileByFileMap.put(file, nextWriteFile);
        this.dataFiles.addLast(nextWriteFile);
        return nextWriteFile;
    }

    public File getFile(int nextNum) {
        String fileName = this.filePrefix + nextNum + this.fileSuffix;
        File file = new File(this.directory, fileName);
        return file;
    }

    synchronized DataFile getDataFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error((Object)("Looking for key " + key + " but not found in fileMap: " + this.fileMap));
            throw new IOException("Could not locate data file " + this.getFile(item.getDataFileId()));
        }
        return dataFile;
    }

    synchronized File getFile(Location item) throws IOException {
        Integer key = item.getDataFileId();
        DataFile dataFile = this.fileMap.get(key);
        if (dataFile == null) {
            LOG.error((Object)("Looking for key " + key + " but not found in fileMap: " + this.fileMap));
            throw new IOException("Could not locate data file " + this.getFile(item.getDataFileId()));
        }
        return dataFile.getFile();
    }

    private DataFile getNextDataFile(DataFile dataFile) {
        return (DataFile)dataFile.getNext();
    }

    public synchronized void close() throws IOException {
        if (!this.started) {
            return;
        }
        Scheduler.cancel(this.cleanupTask);
        this.accessorPool.close();
        this.appender.close();
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.dataFiles.clear();
        this.lastAppendLocation.set(null);
        this.started = false;
    }

    synchronized void cleanup() {
        if (this.accessorPool != null) {
            this.accessorPool.disposeUnused();
        }
    }

    public synchronized boolean delete() throws IOException {
        this.appender.close();
        this.accessorPool.close();
        boolean result = true;
        for (DataFile dataFile : this.fileMap.values()) {
            this.totalLength.addAndGet(-dataFile.getLength());
            result &= dataFile.delete();
        }
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.lastAppendLocation.set(null);
        this.dataFiles = new LinkedNodeList();
        this.accessorPool = new DataFileAccessorPool(this);
        this.appender = new DataFileAppender(this);
        return result;
    }

    public synchronized void removeDataFiles(Set<Integer> files) throws IOException {
        for (Integer key : files) {
            DataFile dataFile;
            if (key >= this.lastAppendLocation.get().getDataFileId() || (dataFile = this.fileMap.get(key)) == null) continue;
            this.forceRemoveDataFile(dataFile);
        }
    }

    private synchronized void forceRemoveDataFile(DataFile dataFile) throws IOException {
        this.accessorPool.disposeDataFileAccessors(dataFile);
        this.fileByFileMap.remove(dataFile.getFile());
        this.fileMap.remove(dataFile.getDataFileId());
        this.totalLength.addAndGet(-dataFile.getLength());
        dataFile.unlink();
        if (this.archiveDataLogs) {
            dataFile.move(this.getDirectoryArchive());
            LOG.debug((Object)("moved data file " + dataFile + " to " + this.getDirectoryArchive()));
        } else if (dataFile.delete()) {
            LOG.debug((Object)("Discarded data file " + dataFile));
        } else {
            LOG.warn((Object)("Failed to discard data file " + dataFile.getFile()));
        }
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public String toString() {
        return this.directory.toString();
    }

    public synchronized void appendedExternally(Location loc, int length) throws IOException {
        DataFile dataFile = null;
        if (this.dataFiles.getTail().getDataFileId().intValue() == loc.getDataFileId()) {
            dataFile = this.dataFiles.getTail();
            dataFile.incrementLength(length);
        } else if (this.dataFiles.getTail().getDataFileId() + 1 == loc.getDataFileId()) {
            int nextNum = loc.getDataFileId();
            File file = this.getFile(nextNum);
            dataFile = new DataFile(file, nextNum, this.preferedFileLength);
            this.fileMap.put(dataFile.getDataFileId(), dataFile);
            this.fileByFileMap.put(file, dataFile);
            this.dataFiles.addLast(dataFile);
        } else {
            throw new IOException("Invalid external append.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Location getNextLocation(Location location) throws IOException, IllegalStateException {
        Location cur = null;
        do {
            if (cur == null) {
                if (location == null) {
                    DataFile head = this.dataFiles.getHead();
                    if (head == null) {
                        return null;
                    }
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else if (location.getSize() == -1) {
                    cur = new Location(location);
                } else {
                    cur = new Location(location);
                    cur.setOffset(location.getOffset() + location.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            DataFile dataFile = this.getDataFile(cur);
            if (dataFile.getLength() <= cur.getOffset()) {
                if ((dataFile = this.getNextDataFile(dataFile)) == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            if (cur.getType() != 0) continue;
            return null;
        } while (cur.getType() != 1);
        return cur;
    }

    public synchronized Location getNextLocation(File file, Location lastLocation, boolean thisFileOnly) throws IllegalStateException, IOException {
        DataFile df = this.fileByFileMap.get(file);
        return this.getNextLocation(df, lastLocation, thisFileOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Location getNextLocation(DataFile dataFile, Location lastLocation, boolean thisFileOnly) throws IOException, IllegalStateException {
        Location cur = null;
        do {
            if (cur == null) {
                if (lastLocation == null) {
                    DataFile head = (DataFile)dataFile.getHeadNode();
                    cur = new Location();
                    cur.setDataFileId(head.getDataFileId());
                    cur.setOffset(0);
                } else {
                    cur = new Location(lastLocation);
                    cur.setOffset(cur.getOffset() + cur.getSize());
                }
            } else {
                cur.setOffset(cur.getOffset() + cur.getSize());
            }
            if (dataFile.getLength() <= cur.getOffset()) {
                if (thisFileOnly) {
                    return null;
                }
                if ((dataFile = this.getNextDataFile(dataFile)) == null) {
                    return null;
                }
                cur.setDataFileId(dataFile.getDataFileId());
                cur.setOffset(0);
            }
            DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
            try {
                reader.readLocationDetails(cur);
            }
            finally {
                this.accessorPool.closeDataFileAccessor(reader);
            }
            if (cur.getType() != 0) continue;
            return null;
        } while (cur.getType() <= 0);
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteSequence read(Location location) throws IOException, IllegalStateException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor reader = this.accessorPool.openDataFileAccessor(dataFile);
        ByteSequence rc = null;
        try {
            rc = reader.readRecord(location);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(reader);
        }
        return rc;
    }

    public synchronized Location write(ByteSequence data, boolean sync) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, sync);
        return loc;
    }

    public synchronized Location write(ByteSequence data, Runnable onComplete) throws IOException, IllegalStateException {
        Location loc = this.appender.storeItem(data, (byte)1, onComplete);
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Location location, ByteSequence data, boolean sync) throws IOException {
        DataFile dataFile = this.getDataFile(location);
        DataFileAccessor updater = this.accessorPool.openDataFileAccessor(dataFile);
        try {
            updater.updateRecord(location, data, sync);
        }
        finally {
            this.accessorPool.closeDataFileAccessor(updater);
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public Map<DataFileAppender.WriteKey, DataFileAppender.WriteCommand> getInflightWrites() {
        return this.inflightWrites;
    }

    public Location getLastAppendLocation() {
        return this.lastAppendLocation.get();
    }

    public void setLastAppendLocation(Location lastSyncedLocation) {
        this.lastAppendLocation.set(lastSyncedLocation);
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public synchronized Integer getCurrentDataFileId() {
        if (this.dataFiles.isEmpty()) {
            return null;
        }
        return this.dataFiles.getTail().getDataFileId();
    }

    public Set<File> getFiles() {
        return this.fileByFileMap.keySet();
    }

    public Map<Integer, DataFile> getFileMap() {
        return new TreeMap<Integer, DataFile>(this.fileMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSize() {
        long tailLength = 0L;
        Journal journal = this;
        synchronized (journal) {
            if (!this.dataFiles.isEmpty()) {
                tailLength = this.dataFiles.getTail().getLength();
            }
        }
        long rc = this.totalLength.get();
        if (tailLength < (long)this.preferedFileLength) {
            rc -= tailLength;
            rc += (long)this.preferedFileLength;
        }
        return rc;
    }

    public void setReplicationTarget(ReplicationTarget replicationTarget) {
        this.replicationTarget = replicationTarget;
    }

    public ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean checksumWrites) {
        this.checksum = checksumWrites;
    }
}

