/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class RecoveryListenerAdapter
implements MessageRecoveryListener {
    private static final Log LOG = LogFactory.getLog(RecoveryListenerAdapter.class);
    private final MessageStore store;
    private final MessageRecoveryListener listener;
    private int count;
    private MessageId lastRecovered;

    RecoveryListenerAdapter(MessageStore store, MessageRecoveryListener listener) {
        this.store = store;
        this.listener = listener;
    }

    public boolean hasSpace() {
        return this.listener.hasSpace();
    }

    public boolean isDuplicate(MessageId id) {
        return this.listener.isDuplicate(id);
    }

    public boolean recoverMessage(Message message) throws Exception {
        if (this.listener.hasSpace()) {
            this.listener.recoverMessage(message);
            this.lastRecovered = message.getMessageId();
            ++this.count;
            return true;
        }
        return false;
    }

    public boolean recoverMessageReference(MessageId ref) throws Exception {
        Message message = this.store.getMessage(ref);
        if (message != null) {
            return this.recoverMessage(message);
        }
        throw new IllegalStateException("Message id " + ref + " could not be recovered from the data store for: " + this.store.getDestination().getQualifiedName() + " - already dispatched");
    }

    MessageId getLastRecoveredMessageId() {
        return this.lastRecovered;
    }

    int size() {
        return this.count;
    }

    void reset() {
        this.count = 0;
    }
}

