/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.kahadb.util.IOHelper;
import org.apache.kahadb.util.LinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFile
extends LinkedNode<DataFile>
implements Comparable<DataFile> {
    protected final File file;
    protected final Integer dataFileId;
    protected int length;

    DataFile(File file, int number, int preferedSize) {
        this.file = file;
        this.dataFileId = number;
        this.length = (int)(file.exists() ? file.length() : 0L);
    }

    public File getFile() {
        return this.file;
    }

    public Integer getDataFileId() {
        return this.dataFileId;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public synchronized void incrementLength(int size) {
        this.length += size;
    }

    public synchronized String toString() {
        return this.file.getName() + " number = " + this.dataFileId + " , length = " + this.length;
    }

    public synchronized RandomAccessFile openRandomAccessFile() throws IOException {
        return new RandomAccessFile(this.file, "rw");
    }

    public synchronized void closeRandomAccessFile(RandomAccessFile file) throws IOException {
        file.close();
    }

    public synchronized boolean delete() throws IOException {
        return this.file.delete();
    }

    public synchronized void move(File targetDirectory) throws IOException {
        IOHelper.moveFile(this.file, targetDirectory);
    }

    @Override
    public int compareTo(DataFile df) {
        return this.dataFileId - df.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DataFile) {
            result = this.compareTo((DataFile)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId;
    }
}

