/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;

public abstract class BaseDestination
implements Destination {
    public static final int MAX_PAGE_SIZE = 200;
    public static final int MAX_BROWSE_PAGE_SIZE = 400;
    protected final ActiveMQDestination destination;
    protected final Broker broker;
    protected final MessageStore store;
    protected SystemUsage systemUsage;
    protected MemoryUsage memoryUsage;
    private boolean producerFlowControl = true;
    private int maxProducersToAudit = 1024;
    private int maxAuditDepth = 2048;
    private boolean enableAudit = true;
    private int maxPageSize = 200;
    private int maxBrowsePageSize = 400;
    private boolean useCache = true;
    private int minimumMessageSize = 1024;
    private boolean lazyDispatch = false;
    private boolean advisoryForSlowConsumers;
    private boolean advisdoryForFastProducers;
    private boolean advisoryForDiscardingMessages;
    private boolean advisoryWhenFull;
    private boolean advisoryForDelivery;
    private boolean advisoryForConsumed;
    private boolean sendAdvisoryIfNoConsumers;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected final BrokerService brokerService;
    protected final Broker regionBroker;
    protected DeadLetterStrategy deadLetterStrategy = DEFAULT_DEAD_LETTER_STRATEGY;

    public BaseDestination(BrokerService brokerService, MessageStore store, ActiveMQDestination destination, DestinationStatistics parentStats) throws Exception {
        this.brokerService = brokerService;
        this.broker = brokerService.getBroker();
        this.store = store;
        this.destination = destination;
        this.destinationStatistics.setEnabled(parentStats.isEnabled());
        this.destinationStatistics.setParent(parentStats);
        this.systemUsage = brokerService.getProducerSystemUsage();
        this.memoryUsage = new MemoryUsage(this.systemUsage.getMemoryUsage(), destination.toString());
        this.memoryUsage.setUsagePortion(1.0f);
        this.regionBroker = brokerService.getRegionBroker();
    }

    public void initialize() throws Exception {
        if (this.store != null) {
            this.store.setMemoryUsage(this.memoryUsage);
        }
    }

    public boolean isProducerFlowControl() {
        return this.producerFlowControl;
    }

    public void setProducerFlowControl(boolean producerFlowControl) {
        this.producerFlowControl = producerFlowControl;
    }

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.destinationStatistics.getProducers().increment();
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        this.destinationStatistics.getProducers().decrement();
    }

    public final MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public final String getName() {
        return this.getActiveMQDestination().getPhysicalName();
    }

    public final MessageStore getMessageStore() {
        return this.store;
    }

    public final boolean isActive() {
        return this.destinationStatistics.getConsumers().getCount() != 0L || this.destinationStatistics.getProducers().getCount() != 0L;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public int getMaxBrowsePageSize() {
        return this.maxBrowsePageSize;
    }

    public void setMaxBrowsePageSize(int maxPageSize) {
        this.maxBrowsePageSize = maxPageSize;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public int getMinimumMessageSize() {
        return this.minimumMessageSize;
    }

    public void setMinimumMessageSize(int minimumMessageSize) {
        this.minimumMessageSize = minimumMessageSize;
    }

    public boolean isLazyDispatch() {
        return this.lazyDispatch;
    }

    public void setLazyDispatch(boolean lazyDispatch) {
        this.lazyDispatch = lazyDispatch;
    }

    protected long getDestinationSequenceId() {
        return this.regionBroker.getBrokerSequenceId();
    }

    public boolean isAdvisoryForSlowConsumers() {
        return this.advisoryForSlowConsumers;
    }

    public void setAdvisoryForSlowConsumers(boolean advisoryForSlowConsumers) {
        this.advisoryForSlowConsumers = advisoryForSlowConsumers;
    }

    public boolean isAdvisoryForDiscardingMessages() {
        return this.advisoryForDiscardingMessages;
    }

    public void setAdvisoryForDiscardingMessages(boolean advisoryForDiscardingMessages) {
        this.advisoryForDiscardingMessages = advisoryForDiscardingMessages;
    }

    public boolean isAdvisoryWhenFull() {
        return this.advisoryWhenFull;
    }

    public void setAdvisoryWhenFull(boolean advisoryWhenFull) {
        this.advisoryWhenFull = advisoryWhenFull;
    }

    public boolean isAdvisoryForDelivery() {
        return this.advisoryForDelivery;
    }

    public void setAdvisoryForDelivery(boolean advisoryForDelivery) {
        this.advisoryForDelivery = advisoryForDelivery;
    }

    public boolean isAdvisoryForConsumed() {
        return this.advisoryForConsumed;
    }

    public void setAdvisoryForConsumed(boolean advisoryForConsumed) {
        this.advisoryForConsumed = advisoryForConsumed;
    }

    public boolean isAdvisdoryForFastProducers() {
        return this.advisdoryForFastProducers;
    }

    public void setAdvisdoryForFastProducers(boolean advisdoryForFastProducers) {
        this.advisdoryForFastProducers = advisdoryForFastProducers;
    }

    public boolean isSendAdvisoryIfNoConsumers() {
        return this.sendAdvisoryIfNoConsumers;
    }

    public void setSendAdvisoryIfNoConsumers(boolean sendAdvisoryIfNoConsumers) {
        this.sendAdvisoryIfNoConsumers = sendAdvisoryIfNoConsumers;
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        if (this.advisoryForConsumed) {
            this.broker.messageConsumed(context, messageReference);
        }
    }

    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        if (this.advisoryForDelivery) {
            this.broker.messageDelivered(context, messageReference);
        }
    }

    public void messageDiscarded(ConnectionContext context, MessageReference messageReference) {
        if (this.advisoryForDiscardingMessages) {
            this.broker.messageDiscarded(context, messageReference);
        }
    }

    public void slowConsumer(ConnectionContext context, Subscription subs) {
        if (this.advisoryForSlowConsumers) {
            this.broker.slowConsumer(context, this, subs);
        }
    }

    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo) {
        if (this.advisdoryForFastProducers) {
            this.broker.fastProducer(context, producerInfo);
        }
    }

    public void isFull(ConnectionContext context, Usage usage) {
        if (this.advisoryWhenFull) {
            this.broker.isFull(context, this, usage);
        }
    }

    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
            this.store.dispose(context);
        }
        this.destinationStatistics.setParent(null);
        this.memoryUsage.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageWithNoConsumers(ConnectionContext context, Message message) throws Exception {
        if (!message.isPersistent() && this.isSendAdvisoryIfNoConsumers() && (this.destination.isQueue() || !AdvisorySupport.isAdvisoryTopic(this.destination))) {
            if (message.getOriginalDestination() != null) {
                message.setOriginalDestination(message.getDestination());
            }
            if (message.getOriginalTransactionId() != null) {
                message.setOriginalTransactionId(message.getTransactionId());
            }
            ActiveMQTopic advisoryTopic = this.destination.isQueue() ? AdvisorySupport.getNoQueueConsumersAdvisoryTopic(this.destination) : AdvisorySupport.getNoTopicConsumersAdvisoryTopic(this.destination);
            message.setDestination(advisoryTopic);
            message.setTransactionId(null);
            boolean originalFlowControl = context.isProducerFlowControl();
            try {
                context.setProducerFlowControl(false);
                ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
                producerExchange.setMutable(false);
                producerExchange.setConnectionContext(context);
                producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
                context.getBroker().send(producerExchange, message);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
    }
}

