/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.command.Message;

public class TimeStampingBrokerPlugin
extends BrokerPluginSupport {
    long zeroExpirationOverride = 0L;
    long ttlCeiling = 0L;

    public void setZeroExpirationOverride(long ttl) {
        this.zeroExpirationOverride = ttl;
    }

    public void setTtlCeiling(long ttlCeiling) {
        this.ttlCeiling = ttlCeiling;
    }

    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        if (message.getTimestamp() > 0L && (message.getBrokerPath() == null || message.getBrokerPath().length == 0)) {
            long oldExpiration = message.getExpiration();
            long newTimeStamp = System.currentTimeMillis();
            message.setTimestamp(newTimeStamp);
            long timeToLive = this.zeroExpirationOverride;
            if (oldExpiration > 0L) {
                long oldTimestamp = message.getTimestamp();
                timeToLive = oldExpiration - oldTimestamp;
            }
            if (timeToLive > 0L && this.ttlCeiling > 0L && timeToLive > this.ttlCeiling) {
                timeToLive = this.ttlCeiling;
            }
            long expiration = timeToLive + newTimeStamp;
            if (timeToLive > 0L && expiration > 0L) {
                message.setExpiration(expiration);
            }
        }
        super.send(producerExchange, message);
    }
}

