/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.state.Tracked;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.failover.BackupTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverTransport
implements CompositeTransport {
    private static final Log LOG = LogFactory.getLog(FailoverTransport.class);
    private TransportListener transportListener;
    private boolean disposed;
    private boolean connected;
    private final CopyOnWriteArrayList<URI> uris = new CopyOnWriteArrayList();
    private final Object reconnectMutex = new Object();
    private final Object backupMutex = new Object();
    private final Object sleepMutex = new Object();
    private final Object listenerMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final Map<Integer, Command> requestMap = new LinkedHashMap<Integer, Command>();
    private URI connectedTransportURI;
    private URI failedConnectTransportURI;
    private final AtomicReference<Transport> connectedTransport = new AtomicReference();
    private final TaskRunner reconnectTask;
    private boolean started;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private long timeout = -1L;
    private boolean useExponentialBackOff = true;
    private boolean randomize = true;
    private boolean initialized;
    private int maxReconnectAttempts;
    private int connectFailures;
    private long reconnectDelay = this.initialReconnectDelay;
    private Exception connectionFailure;
    private boolean firstConnection = true;
    private boolean backup = false;
    private List<BackupTransport> backups = new CopyOnWriteArrayList<BackupTransport>();
    private int backupPoolSize = 1;
    private boolean trackMessages = false;
    private int maxCacheSize = 131072;
    private TransportListener disposedListener = new DefaultTransportListener(){};
    private final TransportListener myTransportListener = this.createTransportListener();

    public FailoverTransport() throws InterruptedIOException {
        this.stateTracker.setTrackTransactions(true);
        this.reconnectTask = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean iterate() {
                boolean result = false;
                boolean buildBackup = true;
                boolean doReconnect = !FailoverTransport.this.disposed;
                Object object = FailoverTransport.this.backupMutex;
                synchronized (object) {
                    if (FailoverTransport.this.connectedTransport.get() == null && !FailoverTransport.this.disposed) {
                        result = FailoverTransport.this.doReconnect();
                        buildBackup = false;
                    }
                }
                if (buildBackup) {
                    FailoverTransport.this.buildBackups();
                } else {
                    result = true;
                    try {
                        FailoverTransport.this.reconnectTask.wakeup();
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Reconnect task has been interrupted.", (Throwable)e);
                    }
                }
                return result;
            }
        }, "ActiveMQ Failover Worker: " + System.identityHashCode(this));
    }

    TransportListener createTransportListener() {
        return new TransportListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCommand(Object o) {
                Command command = (Command)o;
                if (command == null) {
                    return;
                }
                if (command.isResponse()) {
                    Object object = null;
                    Map map = FailoverTransport.this.requestMap;
                    synchronized (map) {
                        object = FailoverTransport.this.requestMap.remove(((Response)command).getCorrelationId());
                    }
                    if (object != null && object.getClass() == Tracked.class) {
                        ((Tracked)object).onResponses();
                    }
                }
                if (!FailoverTransport.this.initialized && command.isBrokerInfo()) {
                    BrokerInfo info = (BrokerInfo)command;
                    BrokerInfo[] peers = info.getPeerBrokerInfos();
                    if (peers != null) {
                        for (int i = 0; i < peers.length; ++i) {
                            String brokerString = peers[i].getBrokerURL();
                            FailoverTransport.this.add(brokerString);
                        }
                    }
                    FailoverTransport.this.initialized = true;
                }
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.onCommand(command);
                }
            }

            public void onException(IOException error) {
                try {
                    FailoverTransport.this.handleTransportFailure(error);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    FailoverTransport.this.transportListener.onException(new InterruptedIOException());
                }
            }

            public void transportInterupted() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportInterupted();
                }
            }

            public void transportResumed() {
                if (FailoverTransport.this.transportListener != null) {
                    FailoverTransport.this.transportListener.transportResumed();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTransportFailure(IOException e) throws InterruptedException {
        Transport transport = this.connectedTransport.getAndSet(null);
        if (transport != null) {
            transport.setTransportListener(this.disposedListener);
            ServiceSupport.dispose(transport);
            Object object = this.reconnectMutex;
            synchronized (object) {
                boolean reconnectOk = false;
                if (this.started) {
                    LOG.warn((Object)("Transport failed to " + this.connectedTransportURI + " , attempting to automatically reconnect due to: " + e));
                    LOG.debug((Object)"Transport failed with the following exception:", (Throwable)e);
                    reconnectOk = true;
                }
                this.initialized = false;
                this.failedConnectTransportURI = this.connectedTransportURI;
                this.connectedTransportURI = null;
                this.connected = false;
                if (reconnectOk) {
                    this.reconnectTask.wakeup();
                }
            }
            if (this.transportListener != null) {
                this.transportListener.transportInterupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.debug((Object)"Started.");
            if (this.started) {
                return;
            }
            this.started = true;
            this.stateTracker.setMaxCacheSize(this.getMaxCacheSize());
            this.stateTracker.setTrackMessages(this.isTrackMessages());
            if (this.connectedTransport.get() != null) {
                this.stateTracker.restore(this.connectedTransport.get());
            } else {
                this.reconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Transport transportToStop = null;
        Object object = this.reconnectMutex;
        synchronized (object) {
            LOG.debug((Object)"Stopped.");
            if (!this.started) {
                return;
            }
            this.started = false;
            this.disposed = true;
            this.connected = false;
            for (BackupTransport t : this.backups) {
                t.setDisposed(true);
            }
            this.backups.clear();
            if (this.connectedTransport.get() != null) {
                transportToStop = this.connectedTransport.getAndSet(null);
            }
            this.reconnectMutex.notifyAll();
        }
        object = this.sleepMutex;
        synchronized (object) {
            this.sleepMutex.notifyAll();
        }
        this.reconnectTask.shutdown();
        if (transportToStop != null) {
            transportToStop.stop();
        }
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public long getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(long reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public Transport getConnectedTransport() {
        return this.connectedTransport.get();
    }

    public URI getConnectedTransportURI() {
        return this.connectedTransportURI;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public int getBackupPoolSize() {
        return this.backupPoolSize;
    }

    public void setBackupPoolSize(int backupPoolSize) {
        this.backupPoolSize = backupPoolSize;
    }

    public boolean isTrackMessages() {
        return this.trackMessages;
    }

    public void setTrackMessages(boolean trackMessages) {
        this.trackMessages = trackMessages;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    private boolean isShutdownCommand(Command command) {
        return command != null && (command.isShutdownInfo() || command instanceof RemoveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        Command command = (Command)o;
        Exception error = null;
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                if (this.isShutdownCommand(command) && this.connectedTransport.get() == null) {
                    if (command.isShutdownInfo()) {
                        return;
                    }
                    if (command instanceof RemoveInfo) {
                        this.stateTracker.track(command);
                        Response response = new Response();
                        response.setCorrelationId(command.getCommandId());
                        this.myTransportListener.onCommand(response);
                        return;
                    }
                }
                int i = 0;
                while (!this.disposed) {
                    try {
                        block28: {
                            Transport transport = this.connectedTransport.get();
                            long start = System.currentTimeMillis();
                            boolean timedout = false;
                            while (transport == null && !this.disposed && this.connectionFailure == null && !Thread.currentThread().isInterrupted()) {
                                LOG.trace((Object)"Waiting for transport to reconnect.");
                                long end = System.currentTimeMillis();
                                if (this.timeout > 0L && end - start > this.timeout) {
                                    timedout = true;
                                    LOG.info((Object)("Failover timed out after " + (end - start) + "ms"));
                                    break;
                                }
                                try {
                                    this.reconnectMutex.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    LOG.debug((Object)("Interupted: " + e), (Throwable)e);
                                }
                                transport = this.connectedTransport.get();
                            }
                            if (transport == null) {
                                error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : (timedout ? new IOException("Failover timeout of " + this.timeout + " ms reached.") : new IOException("Unexpected failure.")));
                                break;
                            }
                            Tracked tracked = this.stateTracker.track(command);
                            Map<Integer, Command> map = this.requestMap;
                            synchronized (map) {
                                if (tracked != null && tracked.isWaitingForResponse()) {
                                    this.requestMap.put(command.getCommandId(), tracked);
                                } else if (tracked == null && command.isResponseRequired()) {
                                    this.requestMap.put(command.getCommandId(), command);
                                }
                            }
                            try {
                                transport.oneway(command);
                                this.stateTracker.trackBack(command);
                            }
                            catch (IOException e) {
                                if (tracked != null) break block28;
                                if (command.isResponseRequired()) {
                                    this.requestMap.remove(command.getCommandId());
                                }
                                throw e;
                            }
                        }
                        return;
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Send oneway attempt: " + i + " failed for command:" + command));
                        }
                        this.handleTransportFailure(e);
                        ++i;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        if (!this.disposed && error != null) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            throw IOExceptionSupport.create(error);
        }
    }

    @Override
    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public Object request(Object command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    @Override
    public void add(URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            if (this.uris.contains(u[i])) continue;
            this.uris.add(u[i]);
        }
        this.reconnect();
    }

    @Override
    public void remove(URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            this.uris.remove(u[i]);
        }
        this.reconnect();
    }

    public void add(String u) {
        try {
            URI uri = new URI(u);
            if (!this.uris.contains(uri)) {
                this.uris.add(uri);
            }
            this.reconnect();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to parse URI: " + u));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.started) {
                LOG.debug((Object)"Waking up reconnect task");
                try {
                    this.reconnectTask.wakeup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                LOG.debug((Object)"Reconnect was triggered but transport is not started yet. Wait for start to connect the transport.");
            }
        }
    }

    private List<URI> getConnectList() {
        ArrayList<URI> l = new ArrayList<URI>(this.uris);
        boolean removed = false;
        if (this.failedConnectTransportURI != null) {
            removed = l.remove(this.failedConnectTransportURI);
        }
        if (this.randomize) {
            for (int i = 0; i < l.size(); ++i) {
                int p = (int)(Math.random() * 100.0 % (double)l.size());
                URI t = l.get(p);
                l.set(p, l.get(i));
                l.set(i, t);
            }
        }
        if (removed) {
            l.add(this.failedConnectTransportURI);
        }
        LOG.debug((Object)("urlList connectionList:" + l));
        return l;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransportListener(TransportListener commandListener) {
        Object object = this.listenerMutex;
        synchronized (object) {
            this.transportListener = commandListener;
            this.listenerMutex.notifyAll();
        }
    }

    @Override
    public <T> T narrow(Class<T> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return target.cast(this);
        }
        Transport transport = this.connectedTransport.get();
        if (transport != null) {
            return transport.narrow(target);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreTransport(Transport t) throws Exception, IOException {
        t.start();
        ConnectionControl cc = new ConnectionControl();
        cc.setFaultTolerant(true);
        t.oneway(cc);
        this.stateTracker.restore(t);
        LinkedHashMap<Integer, Command> tmpMap = null;
        Map<Integer, Command> map = this.requestMap;
        synchronized (map) {
            tmpMap = new LinkedHashMap<Integer, Command>(this.requestMap);
        }
        for (Command command : tmpMap.values()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("restore, replay: " + command));
            }
            t.oneway(command);
        }
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String toString() {
        return this.connectedTransportURI == null ? "unconnected" : this.connectedTransportURI.toString();
    }

    @Override
    public String getRemoteAddress() {
        Transport transport = this.connectedTransport.get();
        if (transport != null) {
            return transport.getRemoteAddress();
        }
        return null;
    }

    @Override
    public boolean isFaultTolerant() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean doReconnect() {
        Exception failure = null;
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.disposed || this.connectionFailure != null) {
                this.reconnectMutex.notifyAll();
            }
            if (this.connectedTransport.get() != null || this.disposed || this.connectionFailure != null) {
                return false;
            }
            List<URI> connectList = this.getConnectList();
            if (connectList.isEmpty()) {
                failure = new IOException("No uris available to connect to.");
            } else {
                Object uri;
                Transport t;
                if (!this.useExponentialBackOff) {
                    this.reconnectDelay = this.initialReconnectDelay;
                }
                Object object2 = this.backupMutex;
                synchronized (object2) {
                    if (this.backup && !this.backups.isEmpty()) {
                        BackupTransport bt = this.backups.remove(0);
                        t = bt.getTransport();
                        uri = bt.getUri();
                        t.setTransportListener(this.myTransportListener);
                        try {
                            if (this.started) {
                                this.restoreTransport(t);
                            }
                            this.reconnectDelay = this.initialReconnectDelay;
                            this.failedConnectTransportURI = null;
                            this.connectedTransportURI = uri;
                            this.connectedTransport.set(t);
                            this.reconnectMutex.notifyAll();
                            this.connectFailures = 0;
                            LOG.info((Object)("Successfully reconnected to backup " + uri));
                            return false;
                        }
                        catch (Exception e) {
                            LOG.debug((Object)"Backup transport failed", (Throwable)e);
                        }
                    }
                }
                Iterator<URI> iter = connectList.iterator();
                while (iter.hasNext() && this.connectedTransport.get() == null && !this.disposed) {
                    URI uri2 = iter.next();
                    t = null;
                    try {
                        LOG.debug((Object)("Attempting connect to: " + uri2));
                        t = TransportFactory.compositeConnect(uri2);
                        t.setTransportListener(this.myTransportListener);
                        t.start();
                        if (this.started) {
                            this.restoreTransport(t);
                        }
                        LOG.debug((Object)"Connection established");
                        this.reconnectDelay = this.initialReconnectDelay;
                        this.connectedTransportURI = uri2;
                        this.connectedTransport.set(t);
                        this.reconnectMutex.notifyAll();
                        this.connectFailures = 0;
                        uri = this.listenerMutex;
                        synchronized (uri) {
                            if (this.transportListener == null) {
                                try {
                                    this.listenerMutex.wait(2000L);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.transportListener != null) {
                            this.transportListener.transportResumed();
                        } else {
                            LOG.debug((Object)"transport resumed by transport listener not set");
                        }
                        if (this.firstConnection) {
                            this.firstConnection = false;
                            LOG.info((Object)("Successfully connected to " + uri2));
                        } else {
                            LOG.info((Object)("Successfully reconnected to " + uri2));
                        }
                        this.connected = true;
                        return false;
                    }
                    catch (Exception e) {
                        failure = e;
                        LOG.debug((Object)("Connect fail to: " + uri2 + ", reason: " + e));
                        if (t == null) continue;
                        try {
                            t.stop();
                        }
                        catch (Exception ee) {
                            LOG.debug((Object)("Stop of failed transport: " + t + " failed with reason: " + ee));
                        }
                    }
                }
            }
            if (this.maxReconnectAttempts > 0 && ++this.connectFailures >= this.maxReconnectAttempts) {
                LOG.error((Object)("Failed to connect to transport after: " + this.connectFailures + " attempt(s)"));
                this.connectionFailure = failure;
                connectList = this.listenerMutex;
                synchronized (connectList) {
                    if (this.transportListener == null) {
                        try {
                            this.listenerMutex.wait(2000L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
                if (this.transportListener != null) {
                    if (this.connectionFailure instanceof IOException) {
                        this.transportListener.onException((IOException)this.connectionFailure);
                    } else {
                        this.transportListener.onException(IOExceptionSupport.create(this.connectionFailure));
                    }
                }
                this.reconnectMutex.notifyAll();
                return false;
            }
        }
        if (!this.disposed) {
            LOG.debug((Object)("Waiting " + this.reconnectDelay + " ms before attempting connection. "));
            object = this.sleepMutex;
            synchronized (object) {
                try {
                    this.sleepMutex.wait(this.reconnectDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.useExponentialBackOff) {
                this.reconnectDelay *= this.backOffMultiplier;
                if (this.reconnectDelay > this.maxReconnectDelay) {
                    this.reconnectDelay = this.maxReconnectDelay;
                }
            }
        }
        return !this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean buildBackups() {
        Object object = this.backupMutex;
        synchronized (object) {
            if (!this.disposed && this.backup && this.backups.size() < this.backupPoolSize) {
                List<URI> connectList = this.getConnectList();
                ArrayList<BackupTransport> disposedList = new ArrayList<BackupTransport>();
                for (BackupTransport bt : this.backups) {
                    if (!bt.isDisposed()) continue;
                    disposedList.add(bt);
                }
                this.backups.removeAll(disposedList);
                disposedList.clear();
                Iterator<URI> iter = connectList.iterator();
                while (iter.hasNext() && this.backups.size() < this.backupPoolSize) {
                    URI uri = iter.next();
                    if (this.connectedTransportURI == null || this.connectedTransportURI.equals(uri)) continue;
                    try {
                        BackupTransport bt = new BackupTransport(this);
                        bt.setUri(uri);
                        if (this.backups.contains(bt)) continue;
                        Transport t = TransportFactory.compositeConnect(uri);
                        t.setTransportListener(bt);
                        t.start();
                        bt.setTransport(t);
                        this.backups.add(bt);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Failed to build backup ", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void reconnect(URI uri) throws IOException {
        this.add(new URI[]{uri});
    }
}

