/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.servicemix.wsn.AbstractCreatePullPoint;
import org.apache.servicemix.wsn.AbstractPullPoint;
import org.apache.servicemix.wsn.jms.JmsPullPoint;
import org.oasis_open.docs.wsn.b_2.CreatePullPoint;

public class JmsCreatePullPoint
extends AbstractCreatePullPoint {
    private ConnectionFactory connectionFactory;
    private Connection connection;

    public JmsCreatePullPoint(String name) {
        super(name);
    }

    public void init() throws Exception {
        if (this.connection == null) {
            this.connection = this.connectionFactory.createConnection();
            this.connection.start();
        }
        super.init();
    }

    public void destroy() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.destroy();
    }

    protected String createPullPointName(CreatePullPoint createPullPointRequest) {
        String name = super.createPullPointName(createPullPointRequest);
        name = name.replace("-", "");
        return name;
    }

    protected AbstractPullPoint createPullPoint(String name) {
        JmsPullPoint pullPoint = new JmsPullPoint(name);
        pullPoint.setManager(this.getManager());
        pullPoint.setConnection(this.connection);
        return pullPoint;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

