/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.network.NetworkConnector;

public class BrokerView
implements BrokerViewMBean {
    ManagedRegionBroker broker;
    private final BrokerService brokerService;
    private final AtomicInteger sessionIdCounter = new AtomicInteger(0);

    public BrokerView(BrokerService brokerService, ManagedRegionBroker managedBroker) throws Exception {
        this.brokerService = brokerService;
        this.broker = managedBroker;
    }

    public ManagedRegionBroker getBroker() {
        return this.broker;
    }

    public void setBroker(ManagedRegionBroker broker) {
        this.broker = broker;
    }

    public String getBrokerId() {
        return this.broker.getBrokerId().toString();
    }

    public String getBrokerName() {
        return this.broker.getBrokerName();
    }

    public void gc() throws Exception {
        this.brokerService.getBroker().gc();
    }

    public void start() throws Exception {
        this.brokerService.start();
    }

    public void stop() throws Exception {
        this.brokerService.stop();
    }

    public void stopGracefully(String connectorName, String queueName, long timeout, long pollInterval) throws Exception {
        this.brokerService.stopGracefully(connectorName, queueName, timeout, pollInterval);
    }

    public long getTotalEnqueueCount() {
        return this.broker.getDestinationStatistics().getEnqueues().getCount();
    }

    public long getTotalDequeueCount() {
        return this.broker.getDestinationStatistics().getDequeues().getCount();
    }

    public long getTotalConsumerCount() {
        return this.broker.getDestinationStatistics().getConsumers().getCount();
    }

    public long getTotalMessageCount() {
        return this.broker.getDestinationStatistics().getMessages().getCount();
    }

    public long getTotalMessagesCached() {
        return this.broker.getDestinationStatistics().getMessagesCached().getCount();
    }

    public int getMemoryPercentUsage() {
        return this.brokerService.getSystemUsage().getMemoryUsage().getPercentUsage();
    }

    public long getMemoryLimit() {
        return this.brokerService.getSystemUsage().getMemoryUsage().getLimit();
    }

    public void setMemoryLimit(long limit) {
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(limit);
    }

    public long getStoreLimit() {
        return this.brokerService.getSystemUsage().getStoreUsage().getLimit();
    }

    public int getStorePercentUsage() {
        return this.brokerService.getSystemUsage().getStoreUsage().getPercentUsage();
    }

    public long getTempLimit() {
        return this.brokerService.getSystemUsage().getTempUsage().getLimit();
    }

    public int getTempPercentUsage() {
        return this.brokerService.getSystemUsage().getTempUsage().getPercentUsage();
    }

    public void setStoreLimit(long limit) {
        this.brokerService.getSystemUsage().getStoreUsage().setLimit(limit);
    }

    public void setTempLimit(long limit) {
        this.brokerService.getSystemUsage().getTempUsage().setLimit(limit);
    }

    public void resetStatistics() {
        this.broker.getDestinationStatistics().reset();
    }

    public void enableStatistics() {
        this.broker.getDestinationStatistics().setEnabled(true);
    }

    public void disableStatistics() {
        this.broker.getDestinationStatistics().setEnabled(false);
    }

    public boolean isStatisticsEnabled() {
        return this.broker.getDestinationStatistics().isEnabled();
    }

    public boolean isPersistent() {
        return this.brokerService.isPersistent();
    }

    public boolean isSlave() {
        return this.brokerService.isSlave();
    }

    public void terminateJVM(int exitCode) {
        System.exit(exitCode);
    }

    public ObjectName[] getTopics() {
        return this.broker.getTopics();
    }

    public ObjectName[] getQueues() {
        return this.broker.getQueues();
    }

    public ObjectName[] getTemporaryTopics() {
        return this.broker.getTemporaryTopics();
    }

    public ObjectName[] getTemporaryQueues() {
        return this.broker.getTemporaryQueues();
    }

    public ObjectName[] getTopicSubscribers() {
        return this.broker.getTopicSubscribers();
    }

    public ObjectName[] getDurableTopicSubscribers() {
        return this.broker.getDurableTopicSubscribers();
    }

    public ObjectName[] getQueueSubscribers() {
        return this.broker.getQueueSubscribers();
    }

    public ObjectName[] getTemporaryTopicSubscribers() {
        return this.broker.getTemporaryTopicSubscribers();
    }

    public ObjectName[] getTemporaryQueueSubscribers() {
        return this.broker.getTemporaryQueueSubscribers();
    }

    public ObjectName[] getInactiveDurableTopicSubscribers() {
        return this.broker.getInactiveDurableTopicSubscribers();
    }

    public String addConnector(String discoveryAddress) throws Exception {
        TransportConnector connector = this.brokerService.addConnector(discoveryAddress);
        connector.start();
        return connector.getName();
    }

    public String addNetworkConnector(String discoveryAddress) throws Exception {
        NetworkConnector connector = this.brokerService.addNetworkConnector(discoveryAddress);
        connector.start();
        return connector.getName();
    }

    public boolean removeConnector(String connectorName) throws Exception {
        TransportConnector connector = this.brokerService.getConnectorByName(connectorName);
        connector.stop();
        return this.brokerService.removeConnector(connector);
    }

    public boolean removeNetworkConnector(String connectorName) throws Exception {
        NetworkConnector connector = this.brokerService.getNetworkConnectorByName(connectorName);
        connector.stop();
        return this.brokerService.removeNetworkConnector(connector);
    }

    public void addTopic(String name) throws Exception {
        this.broker.addDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQTopic(name));
    }

    public void addQueue(String name) throws Exception {
        this.broker.addDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQQueue(name));
    }

    public void removeTopic(String name) throws Exception {
        this.broker.removeDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQTopic(name), 1000L);
    }

    public void removeQueue(String name) throws Exception {
        this.broker.removeDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQQueue(name), 1000L);
    }

    public ObjectName createDurableSubscriber(String clientId, String subscriberName, String topicName, String selector) throws Exception {
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(clientId);
        ConsumerInfo info = new ConsumerInfo();
        ConsumerId consumerId = new ConsumerId();
        consumerId.setConnectionId(clientId);
        consumerId.setSessionId(this.sessionIdCounter.incrementAndGet());
        consumerId.setValue(0L);
        info.setConsumerId(consumerId);
        info.setDestination(new ActiveMQTopic(topicName));
        info.setSubscriptionName(subscriberName);
        info.setSelector(selector);
        Subscription subscription = this.broker.addConsumer(context, info);
        this.broker.removeConsumer(context, info);
        if (subscription != null) {
            return subscription.getObjectName();
        }
        return null;
    }

    public void destroyDurableSubscriber(String clientId, String subscriberName) throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(clientId);
        info.setSubscriptionName(subscriberName);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(clientId);
        this.broker.removeSubscription(context, info);
    }

    public static ConnectionContext getConnectionContext(Broker broker) {
        ConnectionContext adminConnectionContext = broker.getAdminConnectionContext();
        if (adminConnectionContext == null) {
            adminConnectionContext = BrokerView.createAdminConnectionContext(broker);
            broker.setAdminConnectionContext(adminConnectionContext);
        }
        return adminConnectionContext;
    }

    protected static ConnectionContext createAdminConnectionContext(Broker broker) {
        ConnectionContext context = new ConnectionContext();
        context.setBroker(broker);
        return context;
    }

    public void reloadLog4jProperties() throws Throwable {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> logManagerClass = cl.loadClass("org.apache.log4j.LogManager");
            Method resetConfiguration = logManagerClass.getMethod("resetConfiguration", new Class[0]);
            resetConfiguration.invoke(null, new Object[0]);
            URL log4jprops = cl.getResource("log4j.properties");
            if (log4jprops != null) {
                Class<?> propertyConfiguratorClass = cl.loadClass("org.apache.log4j.PropertyConfigurator");
                Method configure = propertyConfiguratorClass.getMethod("configure", URL.class);
                configure.invoke(null, log4jprops);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public String getOpenWireURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("tcp");
        return answer != null ? answer : "";
    }

    public String getStompURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("stomp");
        return answer != null ? answer : "";
    }

    public String getSslURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("ssl");
        return answer != null ? answer : "";
    }

    public String getStompSslURL() {
        String answer = this.brokerService.getTransportConnectorURIsAsMap().get("stomp+ssl");
        return answer != null ? answer : "";
    }

    public String getVMURL() {
        URI answer = this.brokerService.getVmConnectorURI();
        return answer != null ? answer.toString() : "";
    }

    public String getDataDirectory() {
        File file = this.brokerService.getDataDirectoryFile();
        try {
            return file != null ? file.getCanonicalPath() : "";
        }
        catch (IOException e) {
            return "";
        }
    }
}

