/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.AnnotatedMBean;
import org.apache.activemq.broker.jmx.NetworkBridgeView;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.network.ConnectionFilter;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.JMXSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetworkConnector
extends NetworkBridgeConfiguration
implements Service {
    private static final Log LOG = LogFactory.getLog(NetworkConnector.class);
    protected URI localURI;
    protected ConnectionFilter connectionFilter;
    protected ConcurrentHashMap<URI, NetworkBridge> bridges = new ConcurrentHashMap();
    protected ServiceSupport serviceSupport = new ServiceSupport(){

        protected void doStart() throws Exception {
            NetworkConnector.this.handleStart();
        }

        protected void doStop(ServiceStopper stopper) throws Exception {
            NetworkConnector.this.handleStop(stopper);
        }
    };
    private Set<ActiveMQDestination> durableDestinations;
    private List<ActiveMQDestination> excludedDestinations = new CopyOnWriteArrayList<ActiveMQDestination>();
    private List<ActiveMQDestination> dynamicallyIncludedDestinations = new CopyOnWriteArrayList<ActiveMQDestination>();
    private List<ActiveMQDestination> staticallyIncludedDestinations = new CopyOnWriteArrayList<ActiveMQDestination>();
    private BrokerService brokerService;
    private ObjectName objectName;

    public NetworkConnector() {
    }

    public NetworkConnector(URI localURI) {
        this.localURI = localURI;
    }

    public URI getLocalUri() throws URISyntaxException {
        return this.localURI;
    }

    public void setLocalUri(URI localURI) {
        this.localURI = localURI;
    }

    public Set getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(Set<ActiveMQDestination> durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    @Override
    public List<ActiveMQDestination> getExcludedDestinations() {
        return this.excludedDestinations;
    }

    @Override
    public void setExcludedDestinations(List<ActiveMQDestination> excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public void addExcludedDestination(ActiveMQDestination destiantion) {
        this.excludedDestinations.add(destiantion);
    }

    @Override
    public List<ActiveMQDestination> getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    @Override
    public void setStaticallyIncludedDestinations(List<ActiveMQDestination> staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public void addStaticallyIncludedDestination(ActiveMQDestination destiantion) {
        this.staticallyIncludedDestinations.add(destiantion);
    }

    @Override
    public List<ActiveMQDestination> getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    @Override
    public void setDynamicallyIncludedDestinations(List<ActiveMQDestination> dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public void addDynamicallyIncludedDestination(ActiveMQDestination destiantion) {
        this.dynamicallyIncludedDestinations.add(destiantion);
    }

    public ConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public void setConnectionFilter(ConnectionFilter connectionFilter) {
        this.connectionFilter = connectionFilter;
    }

    protected NetworkBridge configureBridge(DemandForwardingBridgeSupport result) {
        List<ActiveMQDestination> destsList = this.getDynamicallyIncludedDestinations();
        ActiveMQDestination[] dests = destsList.toArray(new ActiveMQDestination[destsList.size()]);
        result.setDynamicallyIncludedDestinations(dests);
        destsList = this.getExcludedDestinations();
        dests = destsList.toArray(new ActiveMQDestination[destsList.size()]);
        result.setExcludedDestinations(dests);
        destsList = this.getStaticallyIncludedDestinations();
        dests = destsList.toArray(new ActiveMQDestination[destsList.size()]);
        result.setStaticallyIncludedDestinations(dests);
        if (this.durableDestinations != null) {
            HashSet<ActiveMQDestination> topics = new HashSet<ActiveMQDestination>();
            for (ActiveMQDestination d : this.durableDestinations) {
                if (!d.isTopic()) continue;
                topics.add(d);
            }
            ActiveMQDestination[] dest = new ActiveMQDestination[topics.size()];
            dest = topics.toArray(dest);
            result.setDurableDestinations(dest);
        }
        return result;
    }

    protected Transport createLocalTransport() throws Exception {
        return TransportFactory.connect(this.localURI);
    }

    @Override
    public void start() throws Exception {
        this.serviceSupport.start();
    }

    @Override
    public void stop() throws Exception {
        this.serviceSupport.stop();
    }

    protected void handleStart() throws Exception {
        if (this.localURI == null) {
            throw new IllegalStateException("You must configure the 'localURI' property");
        }
        LOG.info((Object)("Network Connector " + this.getName() + " Started"));
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        LOG.info((Object)("Network Connector " + this.getName() + " Stopped"));
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected void registerNetworkBridgeMBean(NetworkBridge bridge) {
        if (!this.getBrokerService().isUseJmx()) {
            return;
        }
        NetworkBridgeView view = new NetworkBridgeView(bridge);
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            AnnotatedMBean.registerMBean(this.getBrokerService().getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            LOG.debug((Object)("Network bridge could not be registered in JMX: " + e.getMessage()), e);
        }
    }

    protected void unregisterNetworkBridgeMBean(NetworkBridge bridge) {
        if (!this.getBrokerService().isUseJmx()) {
            return;
        }
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            this.getBrokerService().getManagementContext().unregisterMBean(objectName);
        }
        catch (Throwable e) {
            LOG.debug((Object)("Network bridge could not be unregistered in JMX: " + e.getMessage()), e);
        }
    }

    protected ObjectName createNetworkBridgeObjectName(NetworkBridge bridge) throws MalformedObjectNameException {
        ObjectName connectorName = this.getObjectName();
        HashMap<String, String> map = new HashMap<String, String>(connectorName.getKeyPropertyList());
        return new ObjectName(connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart((String)map.get("BrokerName")) + "," + "Type=NetworkBridge," + "NetworkConnectorName=" + JMXSupport.encodeObjectNamePart((String)map.get("NetworkConnectorName")) + "," + "Name=" + JMXSupport.encodeObjectNamePart(JMXSupport.encodeObjectNamePart(bridge.getRemoteAddress())));
    }

    public boolean removeDemandSubscription(ConsumerId consumerId) {
        boolean removeSucceeded = false;
        for (NetworkBridge bridge : this.bridges.values()) {
            DemandForwardingBridgeSupport demandBridge;
            if (!(bridge instanceof DemandForwardingBridgeSupport) || !(demandBridge = (DemandForwardingBridgeSupport)bridge).removeDemandSubscriptionByLocalId(consumerId)) continue;
            removeSucceeded = true;
            break;
        }
        return removeSucceeded;
    }
}

