/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.store.amq.AMQMessageStore;
import org.apache.activemq.store.amq.AMQTopicMessageStore;
import org.apache.activemq.store.amq.AMQTxOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQTx {
    private final Location location;
    private List<AMQTxOperation> operations = new ArrayList<AMQTxOperation>();

    public AMQTx(Location location) {
        this.location = location;
    }

    public void add(AMQMessageStore store, Message msg, Location location) {
        this.operations.add(new AMQTxOperation(0, store.getDestination(), msg, location));
    }

    public void add(AMQMessageStore store, MessageAck ack) {
        this.operations.add(new AMQTxOperation(1, store.getDestination(), ack, null));
    }

    public void add(AMQTopicMessageStore store, JournalTopicAck ack) {
        this.operations.add(new AMQTxOperation(3, store.getDestination(), ack, null));
    }

    public Message[] getMessages() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (AMQTxOperation op : this.operations) {
            if (op.getOperationType() != 0) continue;
            list.add(op.getData());
        }
        Message[] rc = new Message[list.size()];
        list.toArray(rc);
        return rc;
    }

    public MessageAck[] getAcks() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (AMQTxOperation op : this.operations) {
            if (op.getOperationType() != 1) continue;
            list.add(op.getData());
        }
        MessageAck[] rc = new MessageAck[list.size()];
        list.toArray(rc);
        return rc;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<AMQTxOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<AMQTxOperation> operations) {
        this.operations = operations;
    }
}

