/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.data;

import org.apache.activemq.protobuf.Message;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaCommitCommand;
import org.apache.activemq.store.kahadb.data.KahaPrepareCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveDestinationCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaRollbackCommand;
import org.apache.activemq.store.kahadb.data.KahaSubscriptionCommand;
import org.apache.activemq.store.kahadb.data.KahaTraceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KahaEntryType {
    KAHA_TRACE_COMMAND("KAHA_TRACE_COMMAND", 0),
    KAHA_ADD_MESSAGE_COMMAND("KAHA_ADD_MESSAGE_COMMAND", 1),
    KAHA_REMOVE_MESSAGE_COMMAND("KAHA_REMOVE_MESSAGE_COMMAND", 2),
    KAHA_PREPARE_COMMAND("KAHA_PREPARE_COMMAND", 3),
    KAHA_COMMIT_COMMAND("KAHA_COMMIT_COMMAND", 4),
    KAHA_ROLLBACK_COMMAND("KAHA_ROLLBACK_COMMAND", 5),
    KAHA_REMOVE_DESTINATION_COMMAND("KAHA_REMOVE_DESTINATION_COMMAND", 6),
    KAHA_SUBSCRIPTION_COMMAND("KAHA_SUBSCRIPTION_COMMAND", 7);

    private final String name;
    private final int value;

    private KahaEntryType(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public final int getNumber() {
        return this.value;
    }

    public final String toString() {
        return this.name;
    }

    public static KahaEntryType valueOf(int value) {
        switch (value) {
            case 0: {
                return KAHA_TRACE_COMMAND;
            }
            case 1: {
                return KAHA_ADD_MESSAGE_COMMAND;
            }
            case 2: {
                return KAHA_REMOVE_MESSAGE_COMMAND;
            }
            case 3: {
                return KAHA_PREPARE_COMMAND;
            }
            case 4: {
                return KAHA_COMMIT_COMMAND;
            }
            case 5: {
                return KAHA_ROLLBACK_COMMAND;
            }
            case 6: {
                return KAHA_REMOVE_DESTINATION_COMMAND;
            }
            case 7: {
                return KAHA_SUBSCRIPTION_COMMAND;
            }
        }
        return null;
    }

    public Message createMessage() {
        switch (this) {
            case KAHA_TRACE_COMMAND: {
                return new KahaTraceCommand();
            }
            case KAHA_ADD_MESSAGE_COMMAND: {
                return new KahaAddMessageCommand();
            }
            case KAHA_REMOVE_MESSAGE_COMMAND: {
                return new KahaRemoveMessageCommand();
            }
            case KAHA_PREPARE_COMMAND: {
                return new KahaPrepareCommand();
            }
            case KAHA_COMMIT_COMMAND: {
                return new KahaCommitCommand();
            }
            case KAHA_ROLLBACK_COMMAND: {
                return new KahaRollbackCommand();
            }
            case KAHA_REMOVE_DESTINATION_COMMAND: {
                return new KahaRemoveDestinationCommand();
            }
            case KAHA_SUBSCRIPTION_COMMAND: {
                return new KahaSubscriptionCommand();
            }
        }
        return null;
    }
}

