/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jbi;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.common.util.DOMUtil;
import org.apache.servicemix.jbi.jaxp.FragmentStreamReader;
import org.apache.servicemix.jbi.jaxp.StAXSourceTransformer;
import org.apache.servicemix.jbi.jaxp.StaxSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JbiWrapperHelper {
    public static final String WSDL11_WRAPPER_NAMESPACE = "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
    public static final String WSDL11_WRAPPER_PREFIX = "jbi";
    public static final String WSDL11_WRAPPER_MESSAGE_LOCALNAME = "message";
    public static final QName WSDL11_WRAPPER_MESSAGE = new QName("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", "message", "jbi");
    public static final String WSDL11_WRAPPER_MESSAGE_PREFIX = "msg";
    public static final String WSDL11_WRAPPER_TYPE = "type";
    public static final String WSDL11_WRAPPER_NAME = "name";
    public static final String WSDL11_WRAPPER_VERSION = "version";
    public static final String WSDL11_WRAPPER_PART_LOCALNAME = "part";
    public static final QName WSDL11_WRAPPER_PART = new QName("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", "part", "jbi");
    private static final StAXSourceTransformer transformer = new StAXSourceTransformer();

    public static Document createDocument() throws ParserConfigurationException {
        return transformer.createDocument();
    }

    public static void wrap(Document doc) {
        JbiWrapperHelper.wrap(doc, null, null);
    }

    public static void wrap(Document doc, QName type, String name) {
        Element wrapperMsg = doc.createElementNS(WSDL11_WRAPPER_NAMESPACE, "jbi:message");
        wrapperMsg.setAttribute(WSDL11_WRAPPER_VERSION, "1.0");
        if (type != null) {
            if (!"".equals(type.getNamespaceURI())) {
                wrapperMsg.setAttributeNS("http://www.w3.org/2000/xmlns/", WSDL11_WRAPPER_MESSAGE_PREFIX, type.getNamespaceURI());
            }
            wrapperMsg.setAttribute(WSDL11_WRAPPER_TYPE, "msg:" + type.getLocalPart());
        }
        if (name != null) {
            wrapperMsg.setAttribute(WSDL11_WRAPPER_NAME, name);
        }
        Element wrapperPart = doc.createElementNS(WSDL11_WRAPPER_NAMESPACE, "jbi:part");
        wrapperMsg.appendChild(wrapperPart);
        Element el = doc.getDocumentElement();
        doc.replaceChild(wrapperMsg, el);
        wrapperPart.appendChild(el);
    }

    public static Source unwrap(Source source, AtomicBoolean isJbiWrapped) throws XMLStreamException, TransformerException {
        if (source instanceof DOMSource) {
            Element el = DOMUtil.getFirstChildElement((Node)((DOMSource)source).getNode());
            if (el == null) {
                throw new IllegalStateException("Unsupported DOMSource with no element");
            }
            if (WSDL11_WRAPPER_NAMESPACE.equals(el.getNamespaceURI()) && WSDL11_WRAPPER_MESSAGE_LOCALNAME.equals(el.getLocalName())) {
                if ((el = DOMUtil.getFirstChildElement((Node)el)) == null) {
                    throw new IllegalStateException("JBI message has no child element");
                }
                if (!WSDL11_WRAPPER_NAMESPACE.equals(el.getNamespaceURI()) || !WSDL11_WRAPPER_PART_LOCALNAME.equals(el.getLocalName())) {
                    throw new IllegalStateException("Expected a jbi:part element");
                }
                if ((el = DOMUtil.getFirstChildElement((Node)el)) == null) {
                    throw new IllegalStateException("JBI part has no child element");
                }
                isJbiWrapped.set(true);
                source = new DOMSource(el);
            }
        } else {
            XMLStreamReader reader = transformer.toXMLStreamReader(source);
            reader.nextTag();
            if (!reader.isStartElement()) {
                throw new IllegalStateException("expected an element");
            }
            QName qname = reader.getName();
            if (qname.equals(WSDL11_WRAPPER_MESSAGE)) {
                reader.nextTag();
                if (reader.getName().equals(WSDL11_WRAPPER_PART)) {
                    reader.nextTag();
                    isJbiWrapped.set(true);
                } else {
                    throw new IllegalStateException("Expected a jbi:part element");
                }
            }
            source = new StaxSource((XMLStreamReader)new FragmentStreamReader(reader));
        }
        return source;
    }

    public static Source unwrap(Source source) throws TransformerException, XMLStreamException {
        XMLStreamReader reader = new StAXSourceTransformer().toXMLStreamReader(source);
        reader.nextTag();
        if (!reader.isStartElement()) {
            throw new IllegalStateException("expected an element");
        }
        QName qname = reader.getName();
        if (qname.equals(WSDL11_WRAPPER_MESSAGE)) {
            reader.nextTag();
            if (reader.getName().equals(WSDL11_WRAPPER_PART)) {
                reader.nextTag();
            } else {
                throw new IllegalStateException("Expected a jbi:part element");
            }
        }
        source = new StaxSource((XMLStreamReader)new FragmentStreamReader(reader));
        return source;
    }
}

