/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMPendingMessageCursor
extends AbstractPendingMessageCursor {
    private LinkedList<MessageReference> list = new LinkedList();
    private Iterator<MessageReference> iter;

    public VMPendingMessageCursor() {
        this.useCache = false;
    }

    @Override
    public synchronized List<MessageReference> remove(ConnectionContext context, Destination destination) throws Exception {
        ArrayList<MessageReference> rc = new ArrayList<MessageReference>();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MessageReference r = (MessageReference)iterator.next();
            if (r.getRegionDestination() != destination) continue;
            r.decrementReferenceCount();
            rc.add(r);
            iterator.remove();
        }
        return rc;
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.list.isEmpty()) {
            return true;
        }
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            MessageReference node = (MessageReference)iterator.next();
            if (node == QueueMessageReference.NULL_MESSAGE) continue;
            if (!node.isDropped()) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    @Override
    public synchronized void reset() {
        this.iter = this.list.listIterator();
        this.last = null;
    }

    @Override
    public synchronized void addMessageLast(MessageReference node) {
        node.incrementReferenceCount();
        this.list.addLast(node);
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) {
        node.incrementReferenceCount();
        this.list.addFirst(node);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public synchronized MessageReference next() {
        this.last = this.iter.next();
        return this.last;
    }

    @Override
    public synchronized void remove() {
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
        this.iter.remove();
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public synchronized void remove(MessageReference node) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            MessageReference ref = (MessageReference)i.next();
            if (!node.getMessageId().equals(ref.getMessageId())) continue;
            ref.decrementReferenceCount();
            i.remove();
            break;
        }
    }

    @Override
    public LinkedList<MessageReference> pageInList(int maxItems) {
        return this.list;
    }

    @Override
    public boolean isTransient() {
        return true;
    }
}

