/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import java.io.IOException;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.command.MessageDispatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraceBrokerPathPlugin
extends BrokerPluginSupport {
    private String stampProperty = "BrokerPath";
    private static final Log LOG = LogFactory.getLog(TraceBrokerPathPlugin.class);

    public String getStampProperty() {
        return this.stampProperty;
    }

    public void setStampProperty(String stampProperty) {
        this.stampProperty = stampProperty;
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
        try {
            String brokerStamp = (String)messageDispatch.getMessage().getProperty(this.getStampProperty());
            brokerStamp = brokerStamp == null ? this.getBrokerName() : brokerStamp + "," + this.getBrokerName();
            messageDispatch.getMessage().setProperty(this.getStampProperty(), brokerStamp);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Setting broker property failed " + ioe), (Throwable)ioe);
        }
        super.preProcessDispatch(messageDispatch);
    }
}

