/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.MessageReferenceFilter;
import org.apache.activemq.broker.region.QueueBrowserSubscription;
import org.apache.activemq.broker.region.QueueDispatchSelector;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.StoreQueueCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.broker.region.group.MessageGroupHashBucketFactory;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupMapFactory;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue
extends BaseDestination
implements Task,
UsageListener {
    protected static final Log LOG = LogFactory.getLog(Queue.class);
    protected final TaskRunnerFactory taskFactory;
    protected TaskRunner taskRunner;
    private final ReentrantReadWriteLock consumersLock = new ReentrantReadWriteLock();
    protected final List<Subscription> consumers = new ArrayList<Subscription>(50);
    private final ReentrantReadWriteLock messagesLock = new ReentrantReadWriteLock();
    protected PendingMessageCursor messages;
    private final ReentrantReadWriteLock pagedInMessagesLock = new ReentrantReadWriteLock();
    private final LinkedHashMap<MessageId, QueueMessageReference> pagedInMessages = new LinkedHashMap();
    private final ReentrantReadWriteLock pagedInPendingDispatchLock = new ReentrantReadWriteLock();
    private List<QueueMessageReference> pagedInPendingDispatch = new ArrayList<QueueMessageReference>(100);
    private List<QueueMessageReference> redeliveredWaitingDispatch = new ArrayList<QueueMessageReference>();
    private MessageGroupMap messageGroupOwners;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    private MessageGroupMapFactory messageGroupMapFactory = new MessageGroupHashBucketFactory();
    final Lock sendLock = new ReentrantLock();
    private ExecutorService executor;
    protected final Map<MessageId, Runnable> messagesWaitingForSpace = Collections.synchronizedMap(new LinkedHashMap());
    private boolean useConsumerPriority = true;
    private boolean strictOrderDispatch = false;
    private final QueueDispatchSelector dispatchSelector;
    private boolean optimizedDispatch = false;
    private boolean firstConsumer = false;
    private int timeBeforeDispatchStarts = 0;
    private int consumersBeforeDispatchStarts = 0;
    private CountDownLatch consumersBeforeStartsLatch;
    private final AtomicLong pendingWakeups = new AtomicLong();
    private boolean allConsumersExclusiveByDefault = false;
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            Queue.this.asyncWakeup();
        }
    };
    private final Runnable expireMessagesTask = new Runnable(){

        public void run() {
            Queue.this.expireMessages();
        }
    };
    private final Object iteratingMutex = new Object(){};
    private final Scheduler scheduler;
    DelayQueue<TimeoutMessage> flowControlTimeoutMessages = new DelayQueue();
    private final FlowControlTimeoutTask flowControlTimeoutTask = new FlowControlTimeoutTask();
    private static final Comparator<Subscription> orderedCompare = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription s1, Subscription s2) {
            return s2.getConsumerInfo().getPriority() - s1.getConsumerInfo().getPriority();
        }
    };
    LinkedList<BrowserDispatch> browserDispatches = new LinkedList();

    public Queue(BrokerService brokerService, ActiveMQDestination destination, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, store, destination, parentStats);
        this.taskFactory = taskFactory;
        this.dispatchSelector = new QueueDispatchSelector(destination);
        this.scheduler = brokerService.getBroker().getScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getConsumers() {
        this.consumersLock.readLock().lock();
        try {
            ArrayList<Subscription> arrayList = new ArrayList<Subscription>(this.consumers);
            return arrayList;
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
    }

    @Override
    public void initialize() throws Exception {
        if (this.messages == null) {
            this.messages = this.destination.isTemporary() || this.broker == null || this.store == null ? new VMPendingMessageCursor(this.isPrioritizedMessages()) : new StoreQueueCursor(this.broker, this);
        }
        if (this.messages instanceof VMPendingMessageCursor) {
            this.systemUsage = this.brokerService.getSystemUsage();
            this.memoryUsage.setParent(this.systemUsage.getMemoryUsage());
        }
        this.taskRunner = this.taskFactory.createTaskRunner(this, "Queue:" + this.destination.getPhysicalName());
        super.initialize();
        if (this.store != null) {
            this.messages.setSystemUsage(this.systemUsage);
            this.messages.setEnableAudit(this.isEnableAudit());
            this.messages.setMaxAuditDepth(this.getMaxAuditDepth());
            this.messages.setMaxProducersToAudit(this.getMaxProducersToAudit());
            this.messages.setUseCache(this.isUseCache());
            this.messages.setMemoryUsageHighWaterMark(this.getCursorMemoryHighWaterMark());
            if (this.messages.isRecoveryRequired()) {
                this.store.recover(new MessageRecoveryListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean recoverMessage(Message message) {
                        if (message.isExpired()) {
                            if (Queue.this.broker.isExpired(message)) {
                                Queue.this.messageExpired(Queue.this.createConnectionContext(), Queue.this.createMessageReference(message));
                                Queue.this.destinationStatistics.getMessages().increment();
                            }
                            return true;
                        }
                        if (this.hasSpace()) {
                            message.setRegionDestination(Queue.this);
                            Queue.this.messagesLock.writeLock().lock();
                            try {
                                try {
                                    Queue.this.messages.addMessageLast(message);
                                }
                                catch (Exception e) {
                                    LOG.fatal((Object)"Failed to add message to cursor", (Throwable)e);
                                }
                            }
                            finally {
                                Queue.this.messagesLock.writeLock().unlock();
                            }
                            Queue.this.destinationStatistics.getMessages().increment();
                            return true;
                        }
                        return false;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public boolean hasSpace() {
                        return true;
                    }

                    public boolean isDuplicate(MessageId id) {
                        return false;
                    }
                });
            } else {
                int messageCount = this.store.getMessageCount();
                this.destinationStatistics.getMessages().setCount(messageCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        super.addSubscription(context, sub);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            sub.add(context, this);
            this.consumersLock.writeLock().lock();
            try {
                if (this.consumers.size() == 0) {
                    this.firstConsumer = true;
                    if (this.consumersBeforeDispatchStarts != 0) {
                        this.consumersBeforeStartsLatch = new CountDownLatch(this.consumersBeforeDispatchStarts - 1);
                    }
                } else if (this.consumersBeforeStartsLatch != null) {
                    this.consumersBeforeStartsLatch.countDown();
                }
                this.addToConsumerList(sub);
                if (sub.getConsumerInfo().isExclusive() || this.isAllConsumersExclusiveByDefault()) {
                    Subscription exclusiveConsumer = this.dispatchSelector.getExclusiveConsumer();
                    if (exclusiveConsumer == null) {
                        exclusiveConsumer = sub;
                    } else if (sub.getConsumerInfo().getPriority() > exclusiveConsumer.getConsumerInfo().getPriority()) {
                        exclusiveConsumer = sub;
                    }
                    this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                }
            }
            finally {
                this.consumersLock.writeLock().unlock();
            }
            if (sub instanceof QueueBrowserSubscription) {
                QueueBrowserSubscription browserSubscription = (QueueBrowserSubscription)sub;
                this.pagedInMessagesLock.readLock().lock();
                try {
                    BrowserDispatch browserDispatch = new BrowserDispatch(browserSubscription);
                    this.browserDispatches.addLast(browserDispatch);
                }
                finally {
                    this.pagedInMessagesLock.readLock().unlock();
                }
            }
            if (!this.optimizedDispatch && !this.isSlave()) {
                this.wakeup();
            }
        }
        finally {
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        if (this.optimizedDispatch || this.isSlave()) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub, long lastDeiveredSequenceId) throws Exception {
        super.removeSubscription(context, sub, lastDeiveredSequenceId);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("remove sub: " + sub + ", lastDeliveredSeqId: " + lastDeiveredSequenceId + ", dequeues: " + this.getDestinationStatistics().getDequeues().getCount() + ", dispatched: " + this.getDestinationStatistics().getDispatched().getCount() + ", inflight: " + this.getDestinationStatistics().getInflight().getCount()));
            }
            this.consumersLock.writeLock().lock();
            try {
                Subscription exclusiveConsumer;
                this.removeFromConsumerList(sub);
                if (sub.getConsumerInfo().isExclusive()) {
                    exclusiveConsumer = this.dispatchSelector.getExclusiveConsumer();
                    if (exclusiveConsumer == sub) {
                        exclusiveConsumer = null;
                        for (Subscription s : this.consumers) {
                            if (!s.getConsumerInfo().isExclusive() || exclusiveConsumer != null && s.getConsumerInfo().getPriority() <= exclusiveConsumer.getConsumerInfo().getPriority()) continue;
                            exclusiveConsumer = s;
                        }
                        this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                    }
                } else if (this.isAllConsumersExclusiveByDefault()) {
                    exclusiveConsumer = null;
                    for (Subscription s : this.consumers) {
                        if (exclusiveConsumer != null && s.getConsumerInfo().getPriority() <= exclusiveConsumer.getConsumerInfo().getPriority()) continue;
                        exclusiveConsumer = s;
                    }
                    this.dispatchSelector.setExclusiveConsumer(exclusiveConsumer);
                }
                ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
                this.getMessageGroupOwners().removeConsumer(consumerId);
                boolean markAsRedelivered = false;
                MessageReference lastDeliveredRef = null;
                List<MessageReference> unAckedMessages = sub.remove(context, this);
                if (lastDeiveredSequenceId != 0L) {
                    for (MessageReference ref : unAckedMessages) {
                        if (ref.getMessageId().getBrokerSequenceId() != lastDeiveredSequenceId) continue;
                        lastDeliveredRef = ref;
                        markAsRedelivered = true;
                        LOG.debug((Object)("found lastDeliveredSeqID: " + lastDeiveredSequenceId + ", message reference: " + ref.getMessageId()));
                        break;
                    }
                }
                for (MessageReference ref : unAckedMessages) {
                    QueueMessageReference qmr = (QueueMessageReference)ref;
                    if (qmr.getLockOwner() == sub) {
                        qmr.unlock();
                        if (lastDeiveredSequenceId == 0L) {
                            qmr.incrementRedeliveryCounter();
                        } else {
                            if (markAsRedelivered) {
                                qmr.incrementRedeliveryCounter();
                            }
                            if (ref == lastDeliveredRef) {
                                markAsRedelivered = false;
                            }
                        }
                    }
                    this.redeliveredWaitingDispatch.add(qmr);
                }
                if (!this.redeliveredWaitingDispatch.isEmpty()) {
                    this.doDispatch(new ArrayList<QueueMessageReference>());
                }
            }
            finally {
                this.consumersLock.writeLock().unlock();
            }
            if (!this.optimizedDispatch && !this.isSlave()) {
                this.wakeup();
            }
        }
        finally {
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        if (this.optimizedDispatch || this.isSlave()) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.getRoot().messageExpired(context, message);
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.memoryUsage.isFull()) {
            this.isFull(context, this.memoryUsage);
            this.fastProducer(context, producerInfo);
            if (this.isProducerFlowControl() && context.isProducerFlowControl()) {
                if (this.warnOnProducerFlowControl) {
                    this.warnOnProducerFlowControl = false;
                    LOG.info((Object)("Usage Manager Memory Limit (" + this.memoryUsage.getLimit() + ") reached on " + this.getActiveMQDestination().getQualifiedName() + ". Producers will be throttled to the rate at which messages are removed from this destination to prevent flooding it." + " See http://activemq.apache.org/producer-flow-control.html for more info"));
                }
                if (this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException("Usage Manager Memory Limit reached. Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info");
                }
                if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                    final ProducerBrokerExchange producerExchangeCopy = producerExchange.copy();
                    Map<MessageId, Runnable> map = this.messagesWaitingForSpace;
                    synchronized (map) {
                        if (!this.flowControlTimeoutTask.isAlive()) {
                            this.flowControlTimeoutTask.setName(this.getName() + " Producer Flow Control Timeout Task");
                            this.flowControlTimeoutTask.start();
                        }
                        this.messagesWaitingForSpace.put(message.getMessageId(), new Runnable(){

                            public void run() {
                                try {
                                    if (message.isExpired()) {
                                        LOG.error((Object)"expired waiting for space..");
                                        Queue.this.broker.messageExpired(context, message);
                                        Queue.this.destinationStatistics.getExpired().increment();
                                    } else {
                                        Queue.this.doMessageSend(producerExchangeCopy, message);
                                    }
                                    if (sendProducerAck) {
                                        ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                                        context.getConnection().dispatchAsync(ack);
                                    } else {
                                        Response response = new Response();
                                        response.setCorrelationId(message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                                catch (Exception e) {
                                    if (!sendProducerAck && !context.isInRecoveryMode()) {
                                        ExceptionResponse response = new ExceptionResponse(e);
                                        response.setCorrelationId(message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                    LOG.debug((Object)("unexpected exception on deferred send of :" + message), (Throwable)e);
                                }
                            }
                        });
                        if (this.systemUsage.getSendFailIfNoSpaceAfterTimeout() != 0L) {
                            this.flowControlTimeoutMessages.add(new TimeoutMessage(message, context, this.systemUsage.getSendFailIfNoSpaceAfterTimeout()));
                        }
                        this.registerCallbackForNotFullNotification();
                        context.setDontSendReponse(true);
                        return;
                    }
                }
                if (this.memoryUsage.isFull()) {
                    this.waitForSpace(context, this.memoryUsage, "Usage Manager Memory Limit is full. Producer (" + message.getProducerId() + ") stopped to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info");
                }
                if (message.isExpired()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Expired message: " + message));
                    }
                    this.broker.getRoot().messageExpired(context, message);
                    return;
                }
            }
        }
        this.doMessageSend(producerExchange, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    private void registerCallbackForNotFullNotification() {
        if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
            this.sendMessagesWaitingForSpaceTask.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        Future<Object> result = null;
        this.checkUsage(context, message);
        this.sendLock.lockInterruptibly();
        try {
            if (this.store != null && message.isPersistent()) {
                message.getMessageId().setBrokerSequenceId(this.getDestinationSequenceId());
                result = this.store.asyncAddQueueMessage(context, message);
            }
            if (context.isInTransaction()) {
                message.incrementReferenceCount();
                context.getTransaction().addSynchronization(new Synchronization(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void afterCommit() throws Exception {
                        Queue.this.sendLock.lockInterruptibly();
                        try {
                            if (Queue.this.broker.isExpired(message)) {
                                Queue.this.broker.messageExpired(context, message);
                                Queue.this.destinationStatistics.getExpired().increment();
                                return;
                            }
                            Queue.this.sendMessage(message);
                        }
                        finally {
                            Queue.this.sendLock.unlock();
                            message.decrementReferenceCount();
                        }
                        Queue.this.messageSent(context, message);
                    }

                    public void afterRollback() throws Exception {
                        message.decrementReferenceCount();
                    }
                });
            } else {
                this.sendMessage(message);
            }
        }
        finally {
            this.sendLock.unlock();
        }
        if (!context.isInTransaction()) {
            this.messageSent(context, message);
        }
        if (result != null && !result.isCancelled()) {
            try {
                result.get();
            }
            catch (CancellationException e) {
                // empty catch block
            }
        }
    }

    private void checkUsage(ConnectionContext context, Message message) throws ResourceAllocationException, IOException, InterruptedException {
        if (message.isPersistent()) {
            if (this.store != null && this.systemUsage.getStoreUsage().isFull(this.getStoreUsageHighWaterMark())) {
                String logMessage = "Usage Manager Store is Full, " + this.getStoreUsageHighWaterMark() + "% of " + this.systemUsage.getStoreUsage().getLimit() + ". Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info";
                this.waitForSpace(context, this.systemUsage.getStoreUsage(), this.getStoreUsageHighWaterMark(), logMessage);
            }
        } else if (this.messages.getSystemUsage() != null && this.systemUsage.getTempUsage().isFull()) {
            String logMessage = "Usage Manager Temp Store is Full. Stopping producer (" + message.getProducerId() + ") to prevent flooding " + this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info";
            this.waitForSpace(context, this.messages.getSystemUsage().getTempUsage(), logMessage);
        }
    }

    private void expireMessages() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Expiring messages ..");
        }
        AbstractList<Message> browsedMessages = new AbstractList<Message>(){
            int size = 0;

            @Override
            public void add(int index, Message element) {
                ++this.size;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public Message get(int index) {
                return null;
            }
        };
        this.doBrowse((List<Message>)browsedMessages, this.getMaxExpirePageSize());
        this.asyncWakeup();
    }

    @Override
    public void gc() {
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        this.messageConsumed(context, node);
        if (this.store != null && node.isPersistent()) {
            if (ack.getMessageCount() > 0) {
                MessageAck a = new MessageAck();
                ack.copy(a);
                ack = a;
                ack.setFirstMessageId(node.getMessageId());
                ack.setLastMessageId(node.getMessageId());
                ack.setMessageCount(1);
            }
            if (context.isInTransaction()) {
                this.store.removeMessage(context, ack);
            } else {
                this.store.removeAsyncMessage(context, ack);
            }
        }
    }

    Message loadMessage(MessageId messageId) throws IOException {
        Message msg = null;
        if (this.store != null && (msg = this.store.getMessage(messageId)) != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = 0;
        this.messagesLock.readLock().lock();
        try {
            size = this.messages.size();
        }
        finally {
            this.messagesLock.readLock().unlock();
        }
        return "Queue: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.memoryUsage.getPercentUsage() + "%, size=" + size + ", in flight groups=" + this.messageGroupOwners;
    }

    @Override
    public void start() throws Exception {
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
        this.systemUsage.getMemoryUsage().addUsageListener(this);
        this.messages.start();
        if (this.getExpireMessagesPeriod() > 0L) {
            this.scheduler.schedualPeriodically(this.expireMessagesTask, this.getExpireMessagesPeriod());
        }
        this.doPageIn(false);
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.scheduler.cancel(this.expireMessagesTask);
        if (this.flowControlTimeoutTask.isAlive()) {
            this.flowControlTimeoutTask.interrupt();
        }
        if (this.messages != null) {
            this.messages.stop();
        }
        this.systemUsage.getMemoryUsage().removeUsageListener(this);
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
        if (this.store != null) {
            this.store.stop();
        }
    }

    @Override
    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public MessageGroupMap getMessageGroupOwners() {
        if (this.messageGroupOwners == null) {
            this.messageGroupOwners = this.getMessageGroupMapFactory().createMessageGroupMap();
        }
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public MessageGroupMapFactory getMessageGroupMapFactory() {
        return this.messageGroupMapFactory;
    }

    public void setMessageGroupMapFactory(MessageGroupMapFactory messageGroupMapFactory) {
        this.messageGroupMapFactory = messageGroupMapFactory;
    }

    public PendingMessageCursor getMessages() {
        return this.messages;
    }

    public void setMessages(PendingMessageCursor messages) {
        this.messages = messages;
    }

    public boolean isUseConsumerPriority() {
        return this.useConsumerPriority;
    }

    public void setUseConsumerPriority(boolean useConsumerPriority) {
        this.useConsumerPriority = useConsumerPriority;
    }

    public boolean isStrictOrderDispatch() {
        return this.strictOrderDispatch;
    }

    public void setStrictOrderDispatch(boolean strictOrderDispatch) {
        this.strictOrderDispatch = strictOrderDispatch;
    }

    public boolean isOptimizedDispatch() {
        return this.optimizedDispatch;
    }

    public void setOptimizedDispatch(boolean optimizedDispatch) {
        this.optimizedDispatch = optimizedDispatch;
    }

    public int getTimeBeforeDispatchStarts() {
        return this.timeBeforeDispatchStarts;
    }

    public void setTimeBeforeDispatchStarts(int timeBeforeDispatchStarts) {
        this.timeBeforeDispatchStarts = timeBeforeDispatchStarts;
    }

    public int getConsumersBeforeDispatchStarts() {
        return this.consumersBeforeDispatchStarts;
    }

    public void setConsumersBeforeDispatchStarts(int consumersBeforeDispatchStarts) {
        this.consumersBeforeDispatchStarts = consumersBeforeDispatchStarts;
    }

    public void setAllConsumersExclusiveByDefault(boolean allConsumersExclusiveByDefault) {
        this.allConsumersExclusiveByDefault = allConsumersExclusiveByDefault;
    }

    public boolean isAllConsumersExclusiveByDefault() {
        return this.allConsumersExclusiveByDefault;
    }

    private QueueMessageReference createMessageReference(Message message) {
        IndirectMessageReference result = new IndirectMessageReference(message);
        return result;
    }

    @Override
    public Message[] browse() {
        ArrayList<Message> browseList = new ArrayList<Message>();
        this.doBrowse(browseList, this.getMaxBrowsePageSize());
        return browseList.toArray(new Message[browseList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBrowse(List<Message> browseList, int max) {
        block27: {
            ConnectionContext connectionContext = this.createConnectionContext();
            try {
                this.pageInMessages(false);
                ArrayList<MessageReference> toExpire = new ArrayList<MessageReference>();
                this.pagedInPendingDispatchLock.writeLock().lock();
                try {
                    this.addAll(this.pagedInPendingDispatch, browseList, max, toExpire);
                    for (MessageReference ref : toExpire) {
                        this.pagedInPendingDispatch.remove(ref);
                        if (!this.broker.isExpired(ref)) continue;
                        LOG.debug((Object)("expiring from pagedInPending: " + ref));
                        this.messageExpired(connectionContext, ref);
                    }
                }
                finally {
                    this.pagedInPendingDispatchLock.writeLock().unlock();
                }
                toExpire.clear();
                this.pagedInMessagesLock.readLock().lock();
                try {
                    this.addAll(this.pagedInMessages.values(), browseList, max, toExpire);
                }
                finally {
                    this.pagedInMessagesLock.readLock().unlock();
                }
                for (MessageReference ref : toExpire) {
                    if (this.broker.isExpired(ref)) {
                        LOG.debug((Object)("expiring from pagedInMessages: " + ref));
                        this.messageExpired(connectionContext, ref);
                        continue;
                    }
                    this.pagedInMessagesLock.writeLock().lock();
                    try {
                        this.pagedInMessages.remove(ref.getMessageId());
                    }
                    finally {
                        this.pagedInMessagesLock.writeLock().unlock();
                    }
                }
                if (browseList.size() >= this.getMaxBrowsePageSize()) break block27;
                this.messagesLock.writeLock().lock();
                try {
                    try {
                        this.messages.reset();
                        while (this.messages.hasNext() && browseList.size() < max) {
                            MessageReference node = this.messages.next();
                            if (node.isExpired()) {
                                if (this.broker.isExpired(node)) {
                                    LOG.debug((Object)("expiring from messages: " + node));
                                    this.messageExpired(connectionContext, this.createMessageReference(node.getMessage()));
                                }
                                this.messages.remove();
                            } else {
                                this.messages.rollback(node.getMessageId());
                                if (!browseList.contains(node.getMessage())) {
                                    browseList.add(node.getMessage());
                                }
                            }
                            node.decrementReferenceCount();
                        }
                    }
                    finally {
                        this.messages.release();
                    }
                }
                finally {
                    this.messagesLock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Problem retrieving message for browse", (Throwable)e);
            }
        }
    }

    private void addAll(Collection<QueueMessageReference> refs, List<Message> l, int maxBrowsePageSize, List<MessageReference> toExpire) throws Exception {
        Iterator<QueueMessageReference> i = refs.iterator();
        while (i.hasNext() && l.size() < this.getMaxBrowsePageSize()) {
            QueueMessageReference ref = i.next();
            if (ref.isExpired()) {
                toExpire.add(ref);
                continue;
            }
            if (l.contains(ref.getMessage())) continue;
            l.add(ref.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(String id) {
        MessageReference r;
        MessageId msgId = new MessageId(id);
        this.pagedInMessagesLock.readLock().lock();
        try {
            r = this.pagedInMessages.get(msgId);
            if (r != null) {
                Message message = r.getMessage();
                return message;
            }
        }
        finally {
            this.pagedInMessagesLock.readLock().unlock();
        }
        this.messagesLock.readLock().lock();
        try {
            try {
                this.messages.reset();
                while (true) {
                    if (!this.messages.hasNext()) break;
                    r = this.messages.next();
                    r.decrementReferenceCount();
                    this.messages.rollback(r.getMessageId());
                    if (!msgId.equals(r.getMessageId())) continue;
                    Message m = r.getMessage();
                    if (m != null) {
                        Message message = m;
                        return message;
                    }
                    break;
                }
            }
            finally {
                this.messages.release();
            }
        }
        finally {
            this.messagesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws Exception {
        ConnectionContext c = this.createConnectionContext();
        ArrayList<QueueMessageReference> list = null;
        do {
            this.doPageIn(true);
            this.pagedInMessagesLock.readLock().lock();
            try {
                list = new ArrayList<QueueMessageReference>(this.pagedInMessages.values());
            }
            finally {
                this.pagedInMessagesLock.readLock().unlock();
            }
            for (MessageReference messageReference : list) {
                try {
                    QueueMessageReference r = (QueueMessageReference)messageReference;
                    this.removeMessage(c, r);
                }
                catch (IOException e) {}
            }
        } while (!list.isEmpty() && this.destinationStatistics.getMessages().getCount() > 0L);
        if (this.destinationStatistics.getMessages().getCount() > 0L) {
            LOG.warn((Object)(this.getActiveMQDestination().getQualifiedName() + " after purge complete, message count stats report: " + this.destinationStatistics.getMessages().getCount()));
        }
        this.gc();
        this.destinationStatistics.getMessages().setCount(0L);
        this.getMessages().clear();
    }

    public boolean removeMessage(String messageId) throws Exception {
        return this.removeMatchingMessages(this.createMessageIdFilter(messageId), 1) > 0;
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return this.removeMatchingMessages(selector, -1);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return this.removeMatchingMessages(this.createSelectorFilter(selector), maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMatchingMessages(MessageReferenceFilter filter, int maximumMessages) throws Exception {
        int movedCounter = 0;
        CopyOnWriteArraySet<QueueMessageReference> set = new CopyOnWriteArraySet<QueueMessageReference>();
        ConnectionContext context = this.createConnectionContext();
        do {
            this.doPageIn(true);
            this.pagedInMessagesLock.readLock().lock();
            try {
                set.addAll(this.pagedInMessages.values());
            }
            finally {
                this.pagedInMessagesLock.readLock().unlock();
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (!filter.evaluate(context, r)) continue;
                this.removeMessage(context, r);
                set.remove(r);
                if (++movedCounter < maximumMessages || maximumMessages <= 0) continue;
                return movedCounter;
            }
        } while ((long)set.size() < this.destinationStatistics.getMessages().getCount());
        return movedCounter;
    }

    public boolean copyMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessages(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessagesTo(context, selector, dest, -1);
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.copyMatchingMessages(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyMatchingMessages(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        int movedCounter = 0;
        int count = 0;
        CopyOnWriteArraySet<QueueMessageReference> set = new CopyOnWriteArraySet<QueueMessageReference>();
        do {
            int oldMaxSize = this.getMaxPageSize();
            this.setMaxPageSize((int)this.destinationStatistics.getMessages().getCount());
            this.doPageIn(true);
            this.setMaxPageSize(oldMaxSize);
            this.pagedInMessagesLock.readLock().lock();
            try {
                set.addAll(this.pagedInMessages.values());
            }
            finally {
                this.pagedInMessagesLock.readLock().unlock();
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (filter.evaluate(context, r)) {
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        BrokerSupport.resend(context, m, dest);
                        if (++movedCounter >= maximumMessages && maximumMessages > 0) {
                            int n = movedCounter;
                            return n;
                        }
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                }
                ++count;
            }
        } while ((long)count < this.destinationStatistics.getMessages().getCount());
        return movedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMessageTo(ConnectionContext context, Message m, ActiveMQDestination dest) throws Exception {
        QueueMessageReference r = this.createMessageReference(m);
        BrokerSupport.resend(context, m, dest);
        this.removeMessage(context, r);
        this.messagesLock.writeLock().lock();
        try {
            this.messages.rollback(r.getMessageId());
        }
        finally {
            this.messagesLock.writeLock().unlock();
        }
        return true;
    }

    public boolean moveMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, selector, dest, Integer.MAX_VALUE);
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMatchingMessagesTo(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        int movedCounter = 0;
        CopyOnWriteArraySet<QueueMessageReference> set = new CopyOnWriteArraySet<QueueMessageReference>();
        do {
            this.doPageIn(true);
            this.pagedInMessagesLock.readLock().lock();
            try {
                set.addAll(this.pagedInMessages.values());
            }
            finally {
                this.pagedInMessagesLock.readLock().unlock();
            }
            ArrayList list = new ArrayList(set);
            for (MessageReference ref : list) {
                IndirectMessageReference r = (IndirectMessageReference)ref;
                if (!filter.evaluate(context, r)) continue;
                this.moveMessageTo(context, ref.getMessage(), dest);
                set.remove(r);
                if (++movedCounter < maximumMessages || maximumMessages <= 0) continue;
                return movedCounter;
            }
        } while ((long)set.size() < this.destinationStatistics.getMessages().getCount() && set.size() < maximumMessages);
        return movedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BrowserDispatch getNextBrowserDispatch() {
        this.pagedInMessagesLock.readLock().lock();
        try {
            if (this.browserDispatches.isEmpty()) {
                BrowserDispatch browserDispatch = null;
                return browserDispatch;
            }
            BrowserDispatch browserDispatch = this.browserDispatches.removeFirst();
            return browserDispatch;
        }
        finally {
            this.pagedInMessagesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        boolean pageInMoreMessages = false;
        Object object = this.iteratingMutex;
        synchronized (object) {
            boolean bl;
            Map<MessageId, Runnable> map = this.messagesWaitingForSpace;
            synchronized (map) {
                Iterator<Runnable> it = this.messagesWaitingForSpace.values().iterator();
                while (it.hasNext()) {
                    if (!this.memoryUsage.isFull()) {
                        Runnable op = it.next();
                        it.remove();
                        op.run();
                        continue;
                    }
                    this.registerCallbackForNotFullNotification();
                    break;
                }
            }
            if (this.firstConsumer) {
                this.firstConsumer = false;
                try {
                    if (this.consumersBeforeDispatchStarts > 0) {
                        int timeout = 1000;
                        if (this.timeBeforeDispatchStarts > 0) {
                            timeout = this.timeBeforeDispatchStarts;
                        }
                        if (this.consumersBeforeStartsLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(this.consumers.size() + " consumers subscribed. Starting dispatch."));
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(timeout + " ms elapsed and " + this.consumers.size() + " consumers subscribed. Starting dispatch."));
                        }
                    }
                    if (this.timeBeforeDispatchStarts > 0 && this.consumersBeforeDispatchStarts <= 0) {
                        this.iteratingMutex.wait(this.timeBeforeDispatchStarts);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.timeBeforeDispatchStarts + " ms elapsed. Starting dispatch."));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
            BrowserDispatch pendingBrowserDispatch = this.getNextBrowserDispatch();
            this.messagesLock.readLock().lock();
            try {
                pageInMoreMessages |= !this.messages.isEmpty();
            }
            finally {
                this.messagesLock.readLock().unlock();
            }
            this.pagedInPendingDispatchLock.readLock().lock();
            try {
                bl = !this.pagedInPendingDispatch.isEmpty();
            }
            finally {
                this.pagedInPendingDispatchLock.readLock().unlock();
            }
            if ((pageInMoreMessages |= bl) || pendingBrowserDispatch != null || !this.redeliveredWaitingDispatch.isEmpty()) {
                try {
                    this.pageInMessages(pendingBrowserDispatch != null);
                }
                catch (Throwable e) {
                    LOG.error((Object)"Failed to page in more queue messages ", e);
                }
            }
            if (pendingBrowserDispatch != null) {
                ArrayList<QueueMessageReference> alreadyDispatchedMessages = null;
                this.pagedInMessagesLock.readLock().lock();
                try {
                    alreadyDispatchedMessages = new ArrayList<QueueMessageReference>(this.pagedInMessages.values());
                }
                finally {
                    this.pagedInMessagesLock.readLock().unlock();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("dispatch to browser: " + pendingBrowserDispatch.getBrowser() + ", already dispatched/paged count: " + alreadyDispatchedMessages.size()));
                }
                do {
                    try {
                        NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
                        msgContext.setDestination(this.destination);
                        QueueBrowserSubscription browser = pendingBrowserDispatch.getBrowser();
                        for (QueueMessageReference node : alreadyDispatchedMessages) {
                            if (node.isAcked()) continue;
                            ((MessageEvaluationContext)msgContext).setMessageReference(node);
                            if (!browser.matches(node, msgContext)) continue;
                            browser.add(node);
                        }
                        pendingBrowserDispatch.done();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("exception on dispatch to browser: " + pendingBrowserDispatch.getBrowser()), (Throwable)e);
                    }
                } while ((pendingBrowserDispatch = this.getNextBrowserDispatch()) != null);
            }
            if (this.pendingWakeups.get() > 0L) {
                this.pendingWakeups.decrementAndGet();
            }
            return this.pendingWakeups.get() > 0L;
        }
    }

    protected MessageReferenceFilter createMessageIdFilter(final String messageId) {
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) {
                return messageId.equals(r.getMessageId().toString());
            }

            public String toString() {
                return "MessageIdFilter: " + messageId;
            }
        };
    }

    protected MessageReferenceFilter createSelectorFilter(String selector) throws InvalidSelectorException {
        final BooleanExpression selectorExpression = SelectorParser.parse(selector);
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) throws JMSException {
                MessageEvaluationContext messageEvaluationContext = context.getMessageEvaluationContext();
                messageEvaluationContext.setMessageReference(r);
                if (messageEvaluationContext.getDestination() == null) {
                    messageEvaluationContext.setDestination(Queue.this.getActiveMQDestination());
                }
                return selectorExpression.matches(messageEvaluationContext);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessage(ConnectionContext c, QueueMessageReference r) throws IOException {
        this.removeMessage(c, null, r);
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            this.pagedInPendingDispatch.remove(r);
        }
        finally {
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
    }

    protected void removeMessage(ConnectionContext c, Subscription subs, QueueMessageReference r) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(r.getMessageId());
        this.removeMessage(c, subs, r, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessage(ConnectionContext context, Subscription sub, QueueMessageReference reference, MessageAck ack) throws IOException {
        reference.setAcked(true);
        if (!ack.isInTransaction()) {
            this.acknowledge(context, sub, ack, reference);
            this.getDestinationStatistics().getDequeues().increment();
            this.dropMessage(reference);
        } else {
            try {
                this.acknowledge(context, sub, ack, reference);
                context.getTransaction().addSynchronization(new Synchronization(reference){
                    final /* synthetic */ QueueMessageReference val$reference;
                    {
                        this.val$reference = queueMessageReference;
                    }

                    public void afterCommit() throws Exception {
                        Queue.this.getDestinationStatistics().getDequeues().increment();
                        Queue.this.dropMessage(this.val$reference);
                        Queue.this.wakeup();
                    }

                    public void afterRollback() throws Exception {
                        this.val$reference.setAcked(false);
                    }
                });
            }
            catch (Throwable throwable) {
                context.getTransaction().addSynchronization(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        if (ack.isPoisonAck()) {
            this.messagesLock.writeLock().lock();
            try {
                this.messages.rollback(reference.getMessageId());
            }
            finally {
                this.messagesLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropMessage(QueueMessageReference reference) {
        reference.drop();
        this.destinationStatistics.getMessages().decrement();
        this.pagedInMessagesLock.writeLock().lock();
        try {
            this.pagedInMessages.remove(reference.getMessageId());
        }
        finally {
            this.pagedInMessagesLock.writeLock().unlock();
        }
    }

    public void messageExpired(ConnectionContext context, MessageReference reference) {
        this.messageExpired(context, null, reference);
    }

    @Override
    public void messageExpired(ConnectionContext context, Subscription subs, MessageReference reference) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("message expired: " + reference));
        }
        this.broker.messageExpired(context, reference);
        this.destinationStatistics.getExpired().increment();
        try {
            this.removeMessage(context, subs, (QueueMessageReference)reference);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to remove expired Message from the store ", (Throwable)e);
        }
    }

    protected ConnectionContext createConnectionContext() {
        ConnectionContext answer = new ConnectionContext(new NonCachedMessageEvaluationContext());
        answer.setBroker(this.broker);
        answer.getMessageEvaluationContext().setDestination(this.getActiveMQDestination());
        answer.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendMessage(Message msg) throws Exception {
        this.messagesLock.writeLock().lock();
        try {
            this.messages.addMessageLast(msg);
        }
        finally {
            this.messagesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void messageSent(ConnectionContext context, Message msg) throws Exception {
        this.destinationStatistics.getEnqueues().increment();
        this.destinationStatistics.getMessages().increment();
        this.messageDelivered(context, msg);
        this.consumersLock.readLock().lock();
        try {
            if (this.consumers.isEmpty()) {
                this.onMessageWithNoConsumers(context, msg);
            }
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
        this.wakeup();
    }

    @Override
    public void wakeup() {
        if (this.optimizedDispatch || this.isSlave()) {
            this.iterate();
            this.pendingWakeups.incrementAndGet();
        } else {
            this.asyncWakeup();
        }
    }

    private void asyncWakeup() {
        try {
            this.pendingWakeups.incrementAndGet();
            this.taskRunner.wakeup();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Async task tunner failed to wakeup ", (Throwable)e);
        }
    }

    private boolean isSlave() {
        return this.broker.getBrokerService().isSlave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueMessageReference> doPageIn(boolean force) throws Exception {
        ArrayList<QueueMessageReference> result = null;
        ArrayList<QueueMessageReference> resultList = null;
        int toPageIn = Math.min(this.getMaxPageSize(), this.messages.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.destination.getPhysicalName() + " toPageIn: " + toPageIn + ", Inflight: " + this.destinationStatistics.getInflight().getCount() + ", pagedInMessages.size " + this.pagedInMessages.size() + ", enqueueSize: " + this.destinationStatistics.getEnqueues().getCount()));
        }
        if (this.isLazyDispatch() && !force) {
            toPageIn = Math.min(this.getConsumerMessageCountBeforeFull(), toPageIn);
        }
        int pagedInPendingSize = 0;
        this.pagedInPendingDispatchLock.readLock().lock();
        try {
            pagedInPendingSize = this.pagedInPendingDispatch.size();
        }
        finally {
            this.pagedInPendingDispatchLock.readLock().unlock();
        }
        if (toPageIn > 0 && (force || !this.consumers.isEmpty() && pagedInPendingSize < this.getMaxPageSize())) {
            int count = 0;
            result = new ArrayList<QueueMessageReference>(toPageIn);
            this.messagesLock.writeLock().lock();
            try {
                try {
                    this.messages.setMaxBatchSize(toPageIn);
                    this.messages.reset();
                    while (this.messages.hasNext() && count < toPageIn) {
                        MessageReference node = this.messages.next();
                        this.messages.remove();
                        QueueMessageReference ref = this.createMessageReference(node.getMessage());
                        if (ref.isExpired()) {
                            if (this.broker.isExpired(ref)) {
                                this.messageExpired(this.createConnectionContext(), ref);
                                continue;
                            }
                            ref.decrementReferenceCount();
                            continue;
                        }
                        result.add(ref);
                        ++count;
                    }
                }
                finally {
                    this.messages.release();
                }
            }
            finally {
                this.messagesLock.writeLock().unlock();
            }
            this.pagedInMessagesLock.writeLock().lock();
            try {
                resultList = new ArrayList(result.size());
                for (QueueMessageReference ref : result) {
                    if (!this.pagedInMessages.containsKey(ref.getMessageId())) {
                        this.pagedInMessages.put(ref.getMessageId(), ref);
                        resultList.add(ref);
                        continue;
                    }
                    ref.decrementReferenceCount();
                }
            }
            finally {
                this.pagedInMessagesLock.writeLock().unlock();
            }
        }
        resultList = new ArrayList<QueueMessageReference>();
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDispatch(List<QueueMessageReference> list) throws Exception {
        boolean doWakeUp = false;
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            if (!this.redeliveredWaitingDispatch.isEmpty()) {
                this.redeliveredWaitingDispatch = this.doActualDispatch(this.redeliveredWaitingDispatch);
            }
            if (!this.pagedInPendingDispatch.isEmpty()) {
                this.pagedInPendingDispatch = this.doActualDispatch(this.pagedInPendingDispatch);
            }
            if (list != null && !list.isEmpty()) {
                if (this.pagedInPendingDispatch.isEmpty()) {
                    this.pagedInPendingDispatch.addAll(this.doActualDispatch(list));
                } else {
                    for (QueueMessageReference qmr : list) {
                        if (this.pagedInPendingDispatch.contains(qmr)) continue;
                        this.pagedInPendingDispatch.add(qmr);
                    }
                    doWakeUp = true;
                }
            }
        }
        finally {
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        if (doWakeUp) {
            this.asyncWakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueMessageReference> doActualDispatch(List<QueueMessageReference> list) throws Exception {
        ArrayList<Subscription> consumers;
        this.consumersLock.writeLock().lock();
        try {
            if (this.consumers.isEmpty() || this.isSlave()) {
                List<QueueMessageReference> list2 = list;
                return list2;
            }
            consumers = new ArrayList<Subscription>(this.consumers);
        }
        finally {
            this.consumersLock.writeLock().unlock();
        }
        ArrayList<QueueMessageReference> rc = new ArrayList<QueueMessageReference>(list.size());
        HashSet<Subscription> fullConsumers = new HashSet<Subscription>(this.consumers.size());
        for (QueueMessageReference node : list) {
            Subscription target = null;
            int interestCount = 0;
            for (Subscription s : consumers) {
                if (s instanceof QueueBrowserSubscription) {
                    ++interestCount;
                    continue;
                }
                if (this.dispatchSelector.canSelect(s, node)) {
                    if (!fullConsumers.contains(s)) {
                        if (!s.isFull()) {
                            s.add(node);
                            target = s;
                            break;
                        }
                        fullConsumers.add(s);
                    }
                    ++interestCount;
                    continue;
                }
                if (node.isDropped() || node.isAcked() || node.isDropped() && !s.getConsumerInfo().isBrowser()) continue;
                ++interestCount;
            }
            if (target == null && interestCount > 0 || consumers.size() == 0) {
                rc.add(node);
            }
            if (target == null || this.strictOrderDispatch || consumers.size() <= 1 || this.dispatchSelector.isExclusiveConsumer(target)) continue;
            this.consumersLock.writeLock().lock();
            try {
                if (!this.removeFromConsumerList(target)) continue;
                this.addToConsumerList(target);
                consumers = new ArrayList<Subscription>(this.consumers);
            }
            finally {
                this.consumersLock.writeLock().unlock();
            }
        }
        return rc;
    }

    protected void pageInMessages(boolean force) throws Exception {
        this.doDispatch(this.doPageIn(force));
    }

    private void addToConsumerList(Subscription sub) {
        if (this.useConsumerPriority) {
            this.consumers.add(sub);
            Collections.sort(this.consumers, orderedCompare);
        } else {
            this.consumers.add(sub);
        }
    }

    private boolean removeFromConsumerList(Subscription sub) {
        return this.consumers.remove(sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConsumerMessageCountBeforeFull() throws Exception {
        int total = 0;
        boolean zeroPrefetch = false;
        this.consumersLock.readLock().lock();
        try {
            for (Subscription s : this.consumers) {
                zeroPrefetch |= s.getPrefetchSize() == 0;
                int countBeforeFull = s.countBeforeFull();
                total += countBeforeFull;
            }
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
        if (total == 0 && zeroPrefetch) {
            total = 1;
        }
        return total;
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Subscription sub = this.getMatchingSubscription(messageDispatchNotification);
        if (sub != null) {
            QueueMessageReference message = this.getMatchingMessage(messageDispatchNotification);
            sub.add(message);
            sub.processMessageDispatchNotification(messageDispatchNotification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueMessageReference getMatchingMessage(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Message msg;
        QueueMessageReference message = null;
        MessageId messageId = messageDispatchNotification.getMessageId();
        this.pagedInPendingDispatchLock.writeLock().lock();
        try {
            for (QueueMessageReference ref : this.pagedInPendingDispatch) {
                if (!messageId.equals(ref.getMessageId())) continue;
                message = ref;
                this.pagedInPendingDispatch.remove(ref);
                break;
            }
        }
        finally {
            this.pagedInPendingDispatchLock.writeLock().unlock();
        }
        if (message == null) {
            this.pagedInMessagesLock.readLock().lock();
            try {
                message = this.pagedInMessages.get(messageId);
            }
            finally {
                this.pagedInMessagesLock.readLock().unlock();
            }
        }
        if (message == null) {
            this.messagesLock.writeLock().lock();
            try {
                try {
                    this.messages.setMaxBatchSize(this.getMaxPageSize());
                    this.messages.reset();
                    while (this.messages.hasNext()) {
                        MessageReference node = this.messages.next();
                        this.messages.remove();
                        if (!messageId.equals(node.getMessageId())) continue;
                        message = this.createMessageReference(node.getMessage());
                        break;
                    }
                }
                finally {
                    this.messages.release();
                }
            }
            finally {
                this.messagesLock.writeLock().unlock();
            }
        }
        if (message == null && (msg = this.loadMessage(messageId)) != null) {
            message = this.createMessageReference(msg);
        }
        if (message == null) {
            throw new JMSException("Slave broker out of sync with master - Message: " + messageDispatchNotification.getMessageId() + " on " + messageDispatchNotification.getDestination() + " does not exist among pending(" + this.pagedInPendingDispatch.size() + ") for subscription: " + messageDispatchNotification.getConsumerId());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subscription getMatchingSubscription(MessageDispatchNotification messageDispatchNotification) throws JMSException {
        Subscription sub = null;
        this.consumersLock.readLock().lock();
        try {
            for (Subscription s : this.consumers) {
                if (!messageDispatchNotification.getConsumerId().equals(s.getConsumerInfo().getConsumerId())) continue;
                sub = s;
                break;
            }
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
        return sub;
    }

    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage) {
            this.asyncWakeup();
        }
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    class BrowserDispatch {
        QueueBrowserSubscription browser;

        public BrowserDispatch(QueueBrowserSubscription browserSubscription) {
            this.browser = browserSubscription;
            this.browser.incrementQueueRef();
        }

        void done() {
            try {
                this.browser.decrementQueueRef();
            }
            catch (Exception e) {
                LOG.warn((Object)("decrement ref on browser: " + this.browser), (Throwable)e);
            }
        }

        public QueueBrowserSubscription getBrowser() {
            return this.browser;
        }
    }

    final class QueueThread
    extends Thread {
        final Queue queue;

        public QueueThread(Runnable runnable, String name, Queue queue2) {
            super(runnable, name);
            this.queue = queue2;
        }
    }

    class FlowControlTimeoutTask
    extends Thread {
        FlowControlTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    TimeoutMessage timeout;
                    if ((timeout = (TimeoutMessage)Queue.this.flowControlTimeoutMessages.take()) == null) {
                        continue;
                    }
                    Map<MessageId, Runnable> map = Queue.this.messagesWaitingForSpace;
                    synchronized (map) {
                        if (Queue.this.messagesWaitingForSpace.remove(timeout.message.getMessageId()) != null) {
                            ExceptionResponse response = new ExceptionResponse((Throwable)new ResourceAllocationException("Usage Manager Memory Limit reached. Stopping producer (" + timeout.message.getProducerId() + ") to prevent flooding " + Queue.this.getActiveMQDestination().getQualifiedName() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info"));
                            response.setCorrelationId(timeout.message.getCommandId());
                            timeout.context.getConnection().dispatchAsync(response);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + "P roducer Flow Control Timeout Task is stopping"));
                }
                return;
            }
        }
    }

    class TimeoutMessage
    implements Delayed {
        Message message;
        ConnectionContext context;
        long trigger;

        public TimeoutMessage(Message message, ConnectionContext context, long delay) {
            this.message = message;
            this.context = context;
            this.trigger = System.currentTimeMillis() + delay;
        }

        public long getDelay(TimeUnit unit) {
            long n = this.trigger - System.currentTimeMillis();
            return unit.convert(n, TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed delayed) {
            long other = ((TimeoutMessage)delayed).trigger;
            int returnValue = this.trigger < other ? -1 : (this.trigger > other ? 1 : 0);
            return returnValue;
        }
    }
}

