/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jbi;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.wsn.ComponentContextAware;
import org.apache.servicemix.wsn.client.AbstractWSAClient;
import org.apache.servicemix.wsn.client.NotificationBroker;
import org.apache.servicemix.wsn.client.Subscription;
import org.apache.servicemix.wsn.jms.JmsPublisher;
import org.oasis_open.docs.wsn.br_2.PublisherRegistrationFailedFaultType;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.brw_2.PublisherRegistrationFailedFault;
import org.oasis_open.docs.wsn.brw_2.PublisherRegistrationRejectedFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

public class JbiPublisher
extends JmsPublisher
implements ComponentContextAware {
    private ComponentContext context;
    private ServiceEndpoint endpoint;
    private String notificationBrokerAddress;

    public JbiPublisher(String name) {
        super(name);
    }

    public String getNotificationBrokerAddress() {
        return this.notificationBrokerAddress;
    }

    public void setNotificationBrokerAddress(String notificationBrokerAddress) {
        this.notificationBrokerAddress = notificationBrokerAddress;
    }

    protected Object startSubscription() {
        Subscription subscription = null;
        try {
            NotificationBroker broker = new NotificationBroker(this.getContext(), this.publisherReference);
            subscription = broker.subscribe(AbstractWSAClient.createWSA(this.notificationBrokerAddress), "noTopic", null);
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
        return subscription;
    }

    protected void destroySubscription(Object subscription) {
        try {
            ((Subscription)subscription).unsubscribe();
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
    }

    protected void validatePublisher(RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        super.validatePublisher(registerPublisherRequest);
        String[] parts = this.split(AbstractWSAClient.getWSAAddress(this.publisherReference));
        this.endpoint = this.getContext().getEndpoint(new QName(parts[0], parts[1]), parts[2]);
        if (this.endpoint == null) {
            PublisherRegistrationFailedFaultType fault = new PublisherRegistrationFailedFaultType();
            throw new PublisherRegistrationFailedFault("Unable to resolve consumer reference endpoint", fault);
        }
    }

    protected String[] split(String uri) {
        int sep = uri.indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }
}

