/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClassMethod;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationClass {
    private final AnnotationMetadata metadata;
    private final Resource resource;
    private final Map<String, Class<?>> importedResources = new LinkedHashMap();
    private final Set<ConfigurationClassMethod> methods = new LinkedHashSet<ConfigurationClassMethod>();
    private String beanName;

    public ConfigurationClass(MetadataReader metadataReader, String beanName) {
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.beanName = beanName;
    }

    public ConfigurationClass(Class<?> clazz, String beanName) {
        this.metadata = new StandardAnnotationMetadata(clazz);
        this.resource = new DescriptiveResource(clazz.toString());
        this.beanName = beanName;
    }

    public AnnotationMetadata getMetadata() {
        return this.metadata;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getSimpleName() {
        return ClassUtils.getShortName((String)this.getMetadata().getClassName());
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void addMethod(ConfigurationClassMethod method) {
        this.methods.add(method);
    }

    public Set<ConfigurationClassMethod> getMethods() {
        return this.methods;
    }

    public void addImportedResource(String importedResource, Class<?> readerClass) {
        this.importedResources.put(importedResource, readerClass);
    }

    public Map<String, Class<?>> getImportedResources() {
        return this.importedResources;
    }

    public void validate(ProblemReporter problemReporter) {
        HashMap<String, Integer> methodNameCounts = new HashMap<String, Integer>();
        for (ConfigurationClassMethod method : this.methods) {
            String dClassName = method.getMetadata().getDeclaringClassName();
            String methodName = method.getMetadata().getMethodName();
            String fqMethodName = String.valueOf(dClassName) + '#' + methodName;
            Integer currentCount = (Integer)methodNameCounts.get(fqMethodName);
            int newCount = currentCount != null ? currentCount + 1 : 1;
            methodNameCounts.put(fqMethodName, newCount);
        }
        for (String methodName : methodNameCounts.keySet()) {
            int count = (Integer)methodNameCounts.get(methodName);
            if (count <= 1) continue;
            String shortMethodName = methodName.substring(methodName.indexOf(35) + 1);
            problemReporter.error((Problem)new BeanMethodOverloadingProblem(shortMethodName, count));
        }
        if (this.getMetadata().isAnnotated(Configuration.class.getName()) && this.getMetadata().isFinal()) {
            problemReporter.error((Problem)new FinalConfigurationProblem());
        }
        for (ConfigurationClassMethod method : this.methods) {
            method.validate(problemReporter);
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ConfigurationClass && this.getMetadata().getClassName().equals(((ConfigurationClass)other).getMetadata().getClassName());
    }

    public int hashCode() {
        return this.getMetadata().getClassName().hashCode();
    }

    private class BeanMethodOverloadingProblem
    extends Problem {
        public BeanMethodOverloadingProblem(String methodName, int count) {
            super(String.format("@Configuration class '%s' has %s overloaded @Bean methods named '%s'. Only one @Bean method of a given name is allowed within each @Configuration class.", ConfigurationClass.this.getSimpleName(), count, methodName), new Location(ConfigurationClass.this.getResource(), (Object)ConfigurationClass.this.getMetadata()));
        }
    }

    private class FinalConfigurationProblem
    extends Problem {
        public FinalConfigurationProblem() {
            super(String.format("@Configuration class '%s' may not be final. Remove the final modifier to continue.", ConfigurationClass.this.getSimpleName()), new Location(ConfigurationClass.this.getResource(), (Object)ConfigurationClass.this.getMetadata()));
        }
    }
}

