/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.spring;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.wsn.component.WSNDeployableEndpoint;
import org.apache.servicemix.wsn.component.WSNEndpoint;
import org.apache.servicemix.wsn.component.WSNPublisherEndpoint;
import org.apache.servicemix.wsn.component.WSNPullPointEndpoint;
import org.apache.servicemix.wsn.component.WSNSubscriptionEndpoint;
import org.oasis_open.docs.wsn.b_2.CreatePullPoint;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.brw_2.NotificationBroker;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class WSNDeployableEndpointFactoryBean
implements FactoryBean,
InitializingBean {
    private QName service;
    private String endpoint;
    private Resource resource;
    private Object request;

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.request == null && this.resource == null) {
            throw new IllegalStateException("One of request or resource properties must be set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        if (this.request == null && this.resource != null) {
            JAXBContext context = WSNEndpoint.createJAXBContext(NotificationBroker.class);
            InputStream is = this.resource.getInputStream();
            try {
                this.request = context.createUnmarshaller().unmarshal(is);
            }
            finally {
                is.close();
            }
        }
        if (this.request instanceof Subscribe) {
            return new WSNSubscriptionEndpoint((Subscribe)this.request, this.service, this.endpoint);
        }
        if (this.request instanceof CreatePullPoint) {
            return new WSNPullPointEndpoint((CreatePullPoint)this.request, this.service, this.endpoint);
        }
        if (this.request instanceof RegisterPublisher) {
            return new WSNPublisherEndpoint((RegisterPublisher)this.request, this.service, this.endpoint);
        }
        throw new IllegalStateException("Unrecognized request of type " + this.request.getClass());
    }

    public Class getObjectType() {
        return WSNDeployableEndpoint.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

