/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerRegistry {
    private static final Log LOG = LogFactory.getLog(BrokerRegistry.class);
    private static final BrokerRegistry INSTANCE = new BrokerRegistry();
    private final Object mutex = new Object();
    private final Map<String, BrokerService> brokers = new HashMap<String, BrokerService>();

    public static BrokerRegistry getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerService lookup(String brokerName) {
        BrokerService result = null;
        Object object = this.mutex;
        synchronized (object) {
            result = this.brokers.get(brokerName);
            if (result == null && brokerName != null && brokerName.equals("localhost") && (result = this.findFirst()) != null) {
                LOG.warn((Object)("Broker localhost not started so using " + result.getBrokerName() + " instead"));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerService findFirst() {
        Object object = this.mutex;
        synchronized (object) {
            Iterator<BrokerService> iter = this.brokers.values().iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String brokerName, BrokerService broker) {
        Object object = this.mutex;
        synchronized (object) {
            this.brokers.put(brokerName, broker);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String brokerName) {
        Object object = this.mutex;
        synchronized (object) {
            this.brokers.remove(brokerName);
        }
    }

    public Object getRegistryMutext() {
        return this.mutex;
    }

    public Map<String, BrokerService> getBrokers() {
        return Collections.unmodifiableMap(this.brokers);
    }
}

