/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.HashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.AnnotatedMBean;
import org.apache.activemq.broker.jmx.NetworkBridgeView;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.util.JMXSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBeanNetworkListener
implements NetworkBridgeListener {
    private static final Log LOG = LogFactory.getLog(MBeanNetworkListener.class);
    BrokerService brokerService;
    ObjectName connectorName;
    boolean createdByDuplex = false;

    public MBeanNetworkListener(BrokerService brokerService, ObjectName connectorName) {
        this.brokerService = brokerService;
        this.connectorName = connectorName;
    }

    public void bridgeFailed() {
    }

    public void onStart(NetworkBridge bridge) {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        NetworkBridgeView view = new NetworkBridgeView(bridge);
        view.setCreateByDuplex(this.createdByDuplex);
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            AnnotatedMBean.registerMBean(this.brokerService.getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            LOG.debug((Object)("Network bridge could not be registered in JMX: " + e.getMessage()), e);
        }
    }

    public void onStop(NetworkBridge bridge) {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            this.brokerService.getManagementContext().unregisterMBean(objectName);
        }
        catch (Throwable e) {
            LOG.debug((Object)("Network bridge could not be unregistered in JMX: " + e.getMessage()), e);
        }
    }

    protected ObjectName createNetworkBridgeObjectName(NetworkBridge bridge) throws MalformedObjectNameException {
        HashMap<String, String> map = new HashMap<String, String>(this.connectorName.getKeyPropertyList());
        return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart((String)map.get("BrokerName")) + "," + "Type=NetworkBridge," + "NetworkConnectorName=" + JMXSupport.encodeObjectNamePart((String)map.get("NetworkConnectorName")) + "," + "Name=" + JMXSupport.encodeObjectNamePart(JMXSupport.encodeObjectNamePart(bridge.getRemoteAddress())));
    }

    public void setCreatedByDuplex(boolean createdByDuplex) {
        this.createdByDuplex = createdByDuplex;
    }
}

