/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.store.amq.AMQTx;
import org.apache.activemq.store.amq.AMQTxOperation;
import org.apache.activemq.wireformat.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQTxMarshaller
implements Marshaller<AMQTx> {
    private WireFormat wireFormat;

    public AMQTxMarshaller(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    @Override
    public AMQTx readPayload(DataInput dataIn) throws IOException {
        Location location = new Location();
        location.readExternal(dataIn);
        AMQTx result = new AMQTx(location);
        int size = dataIn.readInt();
        for (int i = 0; i < size; ++i) {
            AMQTxOperation op = new AMQTxOperation();
            op.readExternal(this.wireFormat, dataIn);
            result.getOperations().add(op);
        }
        return result;
    }

    @Override
    public void writePayload(AMQTx amqtx, DataOutput dataOut) throws IOException {
        amqtx.getLocation().writeExternal(dataOut);
        List<AMQTxOperation> list = amqtx.getOperations();
        ArrayList<AMQTxOperation> ops = new ArrayList<AMQTxOperation>();
        for (AMQTxOperation op : list) {
            if (op.getOperationType() != 0) continue;
            ops.add(op);
        }
        dataOut.writeInt(ops.size());
        for (AMQTxOperation op : ops) {
            op.writeExternal(this.wireFormat, dataOut);
        }
    }
}

