/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.EmptyBroker;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueRegion;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TempQueueRegion;
import org.apache.activemq.broker.region.TempTopicRegion;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.store.kahadb.plist.PListStore;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.BrokerSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionBroker
extends EmptyBroker {
    public static final String ORIGINAL_EXPIRATION = "originalExpiration";
    private static final Logger LOG = LoggerFactory.getLogger(RegionBroker.class);
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected DestinationFactory destinationFactory;
    protected final Map<ConnectionId, ConnectionState> connectionStates = Collections.synchronizedMap(new HashMap());
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    protected final BrokerService brokerService;
    private boolean started;
    private boolean keepDurableSubsActive;
    private final CopyOnWriteArrayList<Connection> connections = new CopyOnWriteArrayList();
    private final Map<ActiveMQDestination, Destination> destinations = new ConcurrentHashMap<ActiveMQDestination, Destination>();
    private final Map<BrokerId, BrokerInfo> brokerInfos = new HashMap<BrokerId, BrokerInfo>();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;
    private final Map<String, ConnectionContext> clientIdSet = new HashMap<String, ConnectionContext>();
    private final DestinationInterceptor destinationInterceptor;
    private ConnectionContext adminConnectionContext;
    private final Scheduler scheduler;
    private final ThreadPoolExecutor executor;
    private boolean allowTempAutoCreationOnSend;
    private final Runnable purgeInactiveDestinationsTask = new Runnable(){

        @Override
        public void run() {
            RegionBroker.this.purgeInactiveDestinations();
        }
    };

    public RegionBroker(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, SystemUsage memoryManager, DestinationFactory destinationFactory, DestinationInterceptor destinationInterceptor, Scheduler scheduler, ThreadPoolExecutor executor) throws IOException {
        this.brokerService = brokerService;
        this.executor = executor;
        this.scheduler = scheduler;
        if (destinationFactory == null) {
            throw new IllegalArgumentException("null destinationFactory");
        }
        this.sequenceGenerator.setLastSequenceId(destinationFactory.getLastMessageBrokerSequenceId());
        this.destinationFactory = destinationFactory;
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.destinationInterceptor = destinationInterceptor;
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public Map<ActiveMQDestination, Destination> getDestinationMap() {
        Map<ActiveMQDestination, Destination> answer = this.getQueueRegion().getDestinationMap();
        answer.putAll(this.getTopicRegion().getDestinationMap());
        return answer;
    }

    @Override
    public Set<Destination> getDestinations(ActiveMQDestination destination) {
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.getDestinations(destination);
            }
            case 2: {
                return this.topicRegion.getDestinations(destination);
            }
            case 5: {
                return this.tempQueueRegion.getDestinations(destination);
            }
            case 6: {
                return this.tempTopicRegion.getDestinations(destination);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Broker getAdaptor(Class type) {
        if (type.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Region getQueueRegion() {
        return this.queueRegion;
    }

    public Region getTempQueueRegion() {
        return this.tempQueueRegion;
    }

    public Region getTempTopicRegion() {
        return this.tempTopicRegion;
    }

    public Region getTopicRegion() {
        return this.topicRegion;
    }

    protected Region createTempTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempQueueRegion(this, this.brokerService, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new QueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public void start() throws Exception {
        ((TopicRegion)this.topicRegion).setKeepDurableSubsActive(this.keepDurableSubsActive);
        this.started = true;
        this.queueRegion.start();
        this.topicRegion.start();
        this.tempQueueRegion.start();
        this.tempTopicRegion.start();
        int period = this.brokerService.getSchedulePeriodForDestinationPurge();
        if (period > 0) {
            this.scheduler.executePeriodically(this.purgeInactiveDestinationsTask, period);
        }
    }

    @Override
    public void stop() throws Exception {
        this.started = false;
        this.scheduler.cancel(this.purgeInactiveDestinationsTask);
        ServiceStopper ss = new ServiceStopper();
        this.doStop(ss);
        ss.throwFirstException();
        this.clientIdSet.clear();
        this.connections.clear();
        this.destinations.clear();
        this.brokerInfos.clear();
    }

    public PolicyMap getDestinationPolicy() {
        return this.brokerService != null ? this.brokerService.getDestinationPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map<String, ConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            ConnectionContext oldContext = this.clientIdSet.get(clientId);
            if (oldContext != null) {
                if (!context.isFaultTolerant() && !context.isNetworkConnection()) throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + oldContext.getConnection().getRemoteAddress());
                try {
                    this.removeConnection(oldContext, info, new Exception("remove stale client"));
                }
                catch (Exception e) {
                    LOG.warn("Failed to remove stale connection ", (Throwable)e);
                }
            } else {
                this.clientIdSet.put(clientId, context);
            }
        }
        this.connections.add(context.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection disconnect request");
        }
        Map<String, ConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            ConnectionContext oldValue = this.clientIdSet.get(clientId);
            if (oldValue == context && this.isEqual(oldValue.getConnectionId(), info.getConnectionId())) {
                this.clientIdSet.remove(clientId);
            }
        }
        this.connections.remove(context.getConnection());
    }

    protected boolean isEqual(ConnectionId connectionId, ConnectionId connectionId2) {
        return connectionId == connectionId2 || connectionId != null && connectionId.equals(connectionId2);
    }

    @Override
    public Connection[] getClients() throws Exception {
        ArrayList<Connection> l = new ArrayList<Connection>(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    @Override
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean create) throws Exception {
        Destination answer = this.destinations.get(destination);
        if (answer != null) {
            return answer;
        }
        switch (destination.getDestinationType()) {
            case 1: {
                answer = this.queueRegion.addDestination(context, destination, true);
                break;
            }
            case 2: {
                answer = this.topicRegion.addDestination(context, destination, true);
                break;
            }
            case 5: {
                answer = this.tempQueueRegion.addDestination(context, destination, create);
                break;
            }
            case 6: {
                answer = this.tempTopicRegion.addDestination(context, destination, create);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
        this.destinations.put(destination, answer);
        return answer;
    }

    @Override
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (this.destinations.containsKey(destination)) {
            switch (destination.getDestinationType()) {
                case 1: {
                    this.queueRegion.removeDestination(context, destination, timeout);
                    this.removeAdvisoryTopics("Queue.", context, destination, timeout);
                    break;
                }
                case 2: {
                    this.topicRegion.removeDestination(context, destination, timeout);
                    this.removeAdvisoryTopics("Topic.", context, destination, timeout);
                    break;
                }
                case 5: {
                    this.tempQueueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 6: {
                    this.tempTopicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            this.destinations.remove(destination);
        }
    }

    public void removeAdvisoryTopics(String destinationType, ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (this.brokerService.isAdvisorySupport()) {
            ActiveMQDestination[] dests;
            String producerAdvisoryTopic = "ActiveMQ.Advisory.Producer." + destinationType + destination.getPhysicalName();
            String consumerAdvisoryTopic = "ActiveMQ.Advisory.Consumer." + destinationType + destination.getPhysicalName();
            for (ActiveMQDestination dest : dests = this.getDestinations()) {
                String name = dest.getPhysicalName();
                if (!name.equals(producerAdvisoryTopic) && !name.equals(consumerAdvisoryTopic)) continue;
                try {
                    this.removeDestination(context, dest, timeout);
                }
                catch (JMSException ignore) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination(), true);
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.removeDestination(context, info.getDestination(), info.getTimeout());
    }

    @Override
    public ActiveMQDestination[] getDestinations() throws Exception {
        ArrayList<ActiveMQDestination> l = new ArrayList<ActiveMQDestination>(this.getDestinationMap().keySet());
        ActiveMQDestination[] rc = new ActiveMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        Runnable runnable = this.purgeInactiveDestinationsTask;
        synchronized (runnable) {
            if (destination != null) {
                context.getBroker().addDestination(context, destination, true);
                switch (destination.getDestinationType()) {
                    case 1: {
                        this.queueRegion.addProducer(context, info);
                        break;
                    }
                    case 2: {
                        this.topicRegion.addProducer(context, info);
                        break;
                    }
                    case 5: {
                        this.tempQueueRegion.addProducer(context, info);
                        break;
                    }
                    case 6: {
                        this.tempTopicRegion.addProducer(context, info);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        Runnable runnable = this.purgeInactiveDestinationsTask;
        synchronized (runnable) {
            if (destination != null) {
                switch (destination.getDestinationType()) {
                    case 1: {
                        this.queueRegion.removeProducer(context, info);
                        break;
                    }
                    case 2: {
                        this.topicRegion.removeProducer(context, info);
                        break;
                    }
                    case 5: {
                        this.tempQueueRegion.removeProducer(context, info);
                        break;
                    }
                    case 6: {
                        this.tempTopicRegion.removeProducer(context, info);
                    }
                }
            }
        }
    }

    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        if (this.destinationInterceptor != null) {
            this.destinationInterceptor.create(this, context, destination);
        }
        Runnable runnable = this.purgeInactiveDestinationsTask;
        synchronized (runnable) {
            switch (destination.getDestinationType()) {
                case 1: {
                    return this.queueRegion.addConsumer(context, info);
                }
                case 2: {
                    return this.topicRegion.addConsumer(context, info);
                }
                case 5: {
                    return this.tempQueueRegion.addConsumer(context, info);
                }
                case 6: {
                    return this.tempTopicRegion.addConsumer(context, info);
                }
            }
            throw this.createUnknownDestinationTypeException(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        Runnable runnable = this.purgeInactiveDestinationsTask;
        synchronized (runnable) {
            switch (destination.getDestinationType()) {
                case 1: {
                    this.queueRegion.removeConsumer(context, info);
                    break;
                }
                case 2: {
                    this.topicRegion.removeConsumer(context, info);
                    break;
                }
                case 5: {
                    this.tempQueueRegion.removeConsumer(context, info);
                    break;
                }
                case 6: {
                    this.tempTopicRegion.removeConsumer(context, info);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        Runnable runnable = this.purgeInactiveDestinationsTask;
        synchronized (runnable) {
            this.topicRegion.removeSubscription(context, info);
        }
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        message.setBrokerInTime(System.currentTimeMillis());
        if (producerExchange.isMutable() || producerExchange.getRegion() == null || producerExchange.getRegion() != null && producerExchange.getRegion().getDestinationMap().get(message.getDestination()) == null) {
            Region region;
            ActiveMQDestination destination = message.getDestination();
            producerExchange.getConnectionContext().getBroker().addDestination(producerExchange.getConnectionContext(), destination, this.isAllowTempAutoCreationOnSend());
            switch (destination.getDestinationType()) {
                case 1: {
                    region = this.queueRegion;
                    break;
                }
                case 2: {
                    region = this.topicRegion;
                    break;
                }
                case 5: {
                    region = this.tempQueueRegion;
                    break;
                }
                case 6: {
                    region = this.tempTopicRegion;
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            producerExchange.setRegion(region);
            producerExchange.setRegionDestination(null);
        }
        producerExchange.getRegion().send(producerExchange, message);
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        if (consumerExchange.isWildcard() || consumerExchange.getRegion() == null) {
            Region region;
            ActiveMQDestination destination = ack.getDestination();
            switch (destination.getDestinationType()) {
                case 1: {
                    region = this.queueRegion;
                    break;
                }
                case 2: {
                    region = this.topicRegion;
                    break;
                }
                case 5: {
                    region = this.tempQueueRegion;
                    break;
                }
                case 6: {
                    region = this.tempTopicRegion;
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            consumerExchange.setRegion(region);
        }
        consumerExchange.getRegion().acknowledge(consumerExchange, ack);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        ActiveMQDestination destination = pull.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.messagePull(context, pull);
            }
            case 2: {
                return this.topicRegion.messagePull(context, pull);
            }
            case 5: {
                return this.tempQueueRegion.messagePull(context, pull);
            }
            case 6: {
                return this.tempTopicRegion.messagePull(context, pull);
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    @Override
    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    @Override
    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    @Override
    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase();
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected JMSException createUnknownDestinationTypeException(ActiveMQDestination destination) {
        return new JMSException("Unknown destination type: " + destination.getDestinationType());
    }

    @Override
    public synchronized void addBroker(Connection connection, BrokerInfo info) {
        BrokerInfo existing = this.brokerInfos.get(info.getBrokerId());
        if (existing == null) {
            existing = info.copy();
            existing.setPeerBrokerInfos(null);
            this.brokerInfos.put(info.getBrokerId(), existing);
        }
        existing.incrementRefCount();
        LOG.debug(this.getBrokerName() + " addBroker:" + info.getBrokerName() + " brokerInfo size : " + this.brokerInfos.size());
        this.addBrokerInClusterUpdate();
    }

    @Override
    public synchronized void removeBroker(Connection connection, BrokerInfo info) {
        if (info != null) {
            BrokerInfo existing = this.brokerInfos.get(info.getBrokerId());
            if (existing != null && existing.decrementRefCount() == 0) {
                this.brokerInfos.remove(info.getBrokerId());
            }
            LOG.debug(this.getBrokerName() + " removeBroker:" + info.getBrokerName() + " brokerInfo size : " + this.brokerInfos.size());
            this.removeBrokerInClusterUpdate();
        }
    }

    @Override
    public synchronized BrokerInfo[] getPeerBrokerInfos() {
        BrokerInfo[] result = new BrokerInfo[this.brokerInfos.size()];
        result = this.brokerInfos.values().toArray(result);
        return result;
    }

    @Override
    public void preProcessDispatch(MessageDispatch messageDispatch) {
        Message message = messageDispatch.getMessage();
        if (message != null) {
            long endTime = System.currentTimeMillis();
            message.setBrokerOutTime(endTime);
            if (this.getBrokerService().isEnableStatistics()) {
                long totalTime = endTime - message.getBrokerInTime();
                message.getRegionDestination().getDestinationStatistics().getProcessTime().addTime(totalTime);
            }
        }
    }

    @Override
    public void postProcessDispatch(MessageDispatch messageDispatch) {
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        ActiveMQDestination destination = messageDispatchNotification.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 2: {
                this.topicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 5: {
                this.tempQueueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 6: {
                this.tempTopicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public boolean isSlaveBroker() {
        return this.brokerService.isSlave();
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public Set<ActiveMQDestination> getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    protected void doStop(ServiceStopper ss) {
        ss.stop(this.queueRegion);
        ss.stop(this.topicRegion);
        ss.stop(this.tempQueueRegion);
        ss.stop(this.tempTopicRegion);
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }

    public DestinationInterceptor getDestinationInterceptor() {
        return this.destinationInterceptor;
    }

    @Override
    public ConnectionContext getAdminConnectionContext() {
        return this.adminConnectionContext;
    }

    @Override
    public void setAdminConnectionContext(ConnectionContext adminConnectionContext) {
        this.adminConnectionContext = adminConnectionContext;
    }

    public Map<ConnectionId, ConnectionState> getConnectionStates() {
        return this.connectionStates;
    }

    @Override
    public PListStore getTempDataStore() {
        return this.brokerService.getTempDataStore();
    }

    @Override
    public URI getVmConnectorURI() {
        return this.brokerService.getVmConnectorURI();
    }

    @Override
    public void brokerServiceStarted() {
    }

    @Override
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired(MessageReference messageReference) {
        boolean expired = false;
        if (messageReference.isExpired()) {
            try {
                Message message;
                Message message2 = message = messageReference.getMessage();
                synchronized (message2) {
                    expired = this.stampAsExpired(message);
                }
            }
            catch (IOException e) {
                LOG.warn("unexpected exception on message expiry determination for: " + messageReference, (Throwable)e);
            }
        }
        return expired;
    }

    private boolean stampAsExpired(Message message) throws IOException {
        boolean stamped = false;
        if (message.getProperty(ORIGINAL_EXPIRATION) == null) {
            long expiration = message.getExpiration();
            message.setProperty(ORIGINAL_EXPIRATION, new Long(expiration));
            stamped = true;
        }
        return stamped;
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference node, Subscription subscription) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message expired " + node);
        }
        this.getRoot().sendToDeadLetterQueue(context, node, subscription);
    }

    @Override
    public void sendToDeadLetterQueue(ConnectionContext context, MessageReference node, Subscription subscription) {
        try {
            Message message;
            if (node != null && (message = node.getMessage()) != null && node.getRegionDestination() != null) {
                DeadLetterStrategy deadLetterStrategy = node.getRegionDestination().getDeadLetterStrategy();
                if (deadLetterStrategy != null) {
                    if (deadLetterStrategy.isSendToDeadLetterQueue(message)) {
                        message = message.copy();
                        this.stampAsExpired(message);
                        message.setExpiration(0L);
                        if (!message.isPersistent()) {
                            message.setPersistent(true);
                            message.setProperty("originalDeliveryMode", "NON_PERSISTENT");
                        }
                        ActiveMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(message, subscription);
                        if (context.getBroker() == null) {
                            context.setBroker(this.getRoot());
                        }
                        BrokerSupport.resendNoCopy(context, message, deadLetterDestination);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Dead Letter message with no DLQ strategy in place, message id: " + message.getMessageId() + ", destination: " + message.getDestination());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Caught an exception sending to DLQ: " + node, (Throwable)e);
        }
    }

    @Override
    public Broker getRoot() {
        try {
            return this.getBrokerService().getBroker();
        }
        catch (Exception e) {
            LOG.error("Trying to get Root Broker " + e);
            throw new RuntimeException("The broker from the BrokerService should not throw an exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBrokerSequenceId() {
        LongSequenceGenerator longSequenceGenerator = this.sequenceGenerator;
        synchronized (longSequenceGenerator) {
            return this.sequenceGenerator.getNextSequenceId();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        ActiveMQDestination destination = control.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            case 2: {
                this.topicRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            case 5: {
                this.tempQueueRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            case 6: {
                this.tempTopicRegion.processConsumerControl(consumerExchange, control);
                break;
            }
            default: {
                LOG.warn("unmatched destination: " + destination + ", in consumerControl: " + control);
            }
        }
    }

    protected void addBrokerInClusterUpdate() {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients()) continue;
            connector.updateClientClusterInfo();
        }
    }

    protected void removeBrokerInClusterUpdate() {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients() || !connector.isUpdateClusterClientsOnRemove()) continue;
            connector.updateClientClusterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeInactiveDestinations() {
        Runnable runnable = this.purgeInactiveDestinationsTask;
        synchronized (runnable) {
            ArrayList<BaseDestination> list = new ArrayList<BaseDestination>();
            Map<ActiveMQDestination, Destination> map = this.getDestinationMap();
            if (this.isAllowTempAutoCreationOnSend()) {
                map.putAll(this.tempQueueRegion.getDestinationMap());
                map.putAll(this.tempTopicRegion.getDestinationMap());
            }
            long timeStamp = System.currentTimeMillis();
            for (Destination d : map.values()) {
                if (!(d instanceof BaseDestination)) continue;
                BaseDestination bd = (BaseDestination)d;
                bd.markForGC(timeStamp);
                if (!bd.canGC()) continue;
                list.add(bd);
            }
            if (!list.isEmpty()) {
                ConnectionContext context = BrokerSupport.getConnectionContext(this);
                context.setBroker(this);
                for (BaseDestination dest : list) {
                    dest.getLog().info(dest.getName() + " Inactive for longer than " + dest.getInactiveTimoutBeforeGC() + " ms - removing ...");
                    try {
                        this.getRoot().removeDestination(context, dest.getActiveMQDestination(), this.isAllowTempAutoCreationOnSend() ? 1L : 0L);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to remove inactive destination " + dest, (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean isAllowTempAutoCreationOnSend() {
        return this.allowTempAutoCreationOnSend;
    }

    public void setAllowTempAutoCreationOnSend(boolean allowTempAutoCreationOnSend) {
        this.allowTempAutoCreationOnSend = allowTempAutoCreationOnSend;
    }
}

