/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerContextAware;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.ResponseHandler;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompFrameError;
import org.apache.activemq.transport.stomp.StompSubscription;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolConverter.class);
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator transactionIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator tempDestinationGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ConsumerId, StompSubscription> subscriptionsByConsumerId = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ActiveMQDestination> tempDestinations = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tempDestinationAmqToStompMap = new ConcurrentHashMap();
    private final Map<String, LocalTransactionId> transactions = new ConcurrentHashMap<String, LocalTransactionId>();
    private final StompTransport stompTransport;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final FrameTranslator frameTranslator;
    private final FactoryFinder FRAME_TRANSLATOR_FINDER = new FactoryFinder("META-INF/services/org/apache/activemq/transport/frametranslator/");
    private final BrokerContext brokerContext;
    ConnectionInfo connectionInfo = new ConnectionInfo();

    public ProtocolConverter(StompTransport stompTransport, FrameTranslator translator, BrokerContext brokerContext) {
        this.stompTransport = stompTransport;
        this.frameTranslator = translator;
        this.brokerContext = brokerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    protected ResponseHandler createResponseHandler(final StompFrame command) {
        final String receiptId = command.getHeaders().get("receipt");
        if (receiptId != null) {
            return new ResponseHandler(){

                @Override
                public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        Throwable exception = ((ExceptionResponse)response).getException();
                        ProtocolConverter.this.handleException(exception, command);
                    } else {
                        StompFrame sc = new StompFrame();
                        sc.setAction("RECEIPT");
                        sc.setHeaders(new HashMap<String, String>(1));
                        sc.getHeaders().put("receipt-id", receiptId);
                        ProtocolConverter.this.stompTransport.sendToStomp(sc);
                    }
                }
            };
        }
        return null;
    }

    protected void sendToActiveMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.stompTransport.sendToActiveMQ(command);
    }

    protected void sendToStomp(StompFrame command) throws IOException {
        this.stompTransport.sendToStomp(command);
    }

    protected FrameTranslator findTranslator(String header) {
        FrameTranslator translator = this.frameTranslator;
        try {
            if (header != null && (translator = (FrameTranslator)this.FRAME_TRANSLATOR_FINDER.newInstance(header)) instanceof BrokerContextAware) {
                ((BrokerContextAware)((Object)translator)).setBrokerContext(this.brokerContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return translator;
    }

    public void onStompCommand(StompFrame command) throws IOException, JMSException {
        block12: {
            try {
                if (command.getClass() == StompFrameError.class) {
                    throw ((StompFrameError)command).getException();
                }
                String action = command.getAction();
                if (action.startsWith("SEND")) {
                    this.onStompSend(command);
                    break block12;
                }
                if (action.startsWith("ACK")) {
                    this.onStompAck(command);
                    break block12;
                }
                if (action.startsWith("BEGIN")) {
                    this.onStompBegin(command);
                    break block12;
                }
                if (action.startsWith("COMMIT")) {
                    this.onStompCommit(command);
                    break block12;
                }
                if (action.startsWith("ABORT")) {
                    this.onStompAbort(command);
                    break block12;
                }
                if (action.startsWith("SUB")) {
                    this.onStompSubscribe(command);
                    break block12;
                }
                if (action.startsWith("UNSUB")) {
                    this.onStompUnsubscribe(command);
                    break block12;
                }
                if (action.startsWith("CONNECT")) {
                    this.onStompConnect(command);
                    break block12;
                }
                if (action.startsWith("DISCONNECT")) {
                    this.onStompDisconnect(command);
                    break block12;
                }
                throw new ProtocolException("Unknown STOMP action: " + action);
            }
            catch (ProtocolException e) {
                this.handleException(e, command);
                if (!e.isFatal()) break block12;
                this.getStompTransport().onException(e);
            }
        }
    }

    protected void handleException(Throwable exception, StompFrame command) throws IOException {
        String receiptId;
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception detail", exception);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter stream = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        exception.printStackTrace(stream);
        stream.close();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("message", exception.getMessage());
        if (command != null && (receiptId = command.getHeaders().get("receipt")) != null) {
            headers.put("receipt-id", receiptId);
        }
        StompFrame errorMessage = new StompFrame("ERROR", headers, baos.toByteArray());
        this.sendToStomp(errorMessage);
    }

    protected void onStompSend(StompFrame command) throws IOException, JMSException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        headers.remove("transaction");
        ActiveMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId());
        message.setMessageId(id);
        message.setJMSTimestamp(System.currentTimeMillis());
        if (stompTx != null) {
            TransactionId activemqTx = this.transactions.get(stompTx);
            if (activemqTx == null) {
                throw new ProtocolException("Invalid transaction id: " + stompTx);
            }
            message.setTransactionId(activemqTx);
        }
        message.onSend();
        this.sendToActiveMQ(message, this.createResponseHandler(command));
    }

    protected void onStompAck(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String messageId = headers.get("message-id");
        if (messageId == null) {
            throw new ProtocolException("ACK received without a message-id to acknowledge!");
        }
        TransactionId activemqTx = null;
        String stompTx = headers.get("transaction");
        if (stompTx != null && (activemqTx = (TransactionId)this.transactions.get(stompTx)) == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        boolean acked = false;
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            MessageAck ack = sub.onStompMessageAck(messageId, activemqTx);
            if (ack == null) continue;
            ack.setTransactionId(activemqTx);
            this.sendToActiveMQ(ack, this.createResponseHandler(command));
            acked = true;
            break;
        }
        if (!acked) {
            throw new ProtocolException("Unexpected ACK received for message-id [" + messageId + "]");
        }
    }

    protected void onStompBegin(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (!headers.containsKey("transaction")) {
            throw new ProtocolException("Must specify the transaction you are beginning");
        }
        if (this.transactions.get(stompTx) != null) {
            throw new ProtocolException("The transaction was allready started: " + stompTx);
        }
        LocalTransactionId activemqTx = new LocalTransactionId(this.connectionId, this.transactionIdGenerator.getNextSequenceId());
        this.transactions.put(stompTx, activemqTx);
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)0);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompCommit(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId activemqTx = this.transactions.remove(stompTx);
        if (activemqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            sub.onStompCommit(activemqTx);
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)2);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompAbort(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        String stompTx = headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId activemqTx = this.transactions.remove(stompTx);
        if (activemqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        for (StompSubscription sub : this.subscriptionsByConsumerId.values()) {
            try {
                sub.onStompAbort(activemqTx);
            }
            catch (Exception e) {
                throw new ProtocolException("Transaction abort failed", false, e);
            }
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)4);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompSubscribe(StompFrame command) throws ProtocolException {
        this.checkConnected();
        FrameTranslator translator = this.findTranslator(command.getHeaders().get("transformation"));
        Map<String, String> headers = command.getHeaders();
        String subscriptionId = headers.get("id");
        String destination = headers.get("destination");
        ActiveMQDestination actualDest = translator.convertDestination(this, destination);
        if (actualDest == null) {
            throw new ProtocolException("Invalid Destination.");
        }
        ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setPrefetchSize(1000);
        consumerInfo.setDispatchAsync(true);
        String selector = headers.remove("selector");
        consumerInfo.setSelector(selector);
        IntrospectionSupport.setProperties(consumerInfo, headers, "activemq.");
        consumerInfo.setDestination(translator.convertDestination(this, destination));
        StompSubscription stompSubscription = new StompSubscription(this, subscriptionId, consumerInfo, headers.get("transformation"));
        stompSubscription.setDestination(actualDest);
        String ackMode = headers.get("ack");
        if ("client".equals(ackMode)) {
            stompSubscription.setAckMode("client");
        } else if ("client-individual".equals(ackMode)) {
            stompSubscription.setAckMode("client-individual");
        } else {
            stompSubscription.setAckMode("auto");
        }
        this.subscriptionsByConsumerId.put(id, stompSubscription);
        this.sendToActiveMQ(consumerInfo, this.createResponseHandler(command));
    }

    protected void onStompUnsubscribe(StompFrame command) throws ProtocolException {
        String subscriptionId;
        this.checkConnected();
        Map<String, String> headers = command.getHeaders();
        ActiveMQDestination destination = null;
        String o = headers.get("destination");
        if (o != null) {
            destination = this.findTranslator(command.getHeaders().get("transformation")).convertDestination(this, o);
        }
        if ((subscriptionId = headers.get("id")) == null && destination == null) {
            throw new ProtocolException("Must specify the subscriptionId or the destination you are unsubscribing from");
        }
        String durable = command.getHeaders().get("activemq.subscriptionName");
        if (durable != null) {
            RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
            info.setClientId(durable);
            info.setSubscriptionName(durable);
            info.setConnectionId(this.connectionId);
            this.sendToActiveMQ(info, this.createResponseHandler(command));
            return;
        }
        Iterator<StompSubscription> iter = this.subscriptionsByConsumerId.values().iterator();
        while (iter.hasNext()) {
            StompSubscription sub = iter.next();
            if ((subscriptionId == null || !subscriptionId.equals(sub.getSubscriptionId())) && (destination == null || !destination.equals(sub.getDestination()))) continue;
            this.sendToActiveMQ(sub.getConsumerInfo().createRemoveCommand(), this.createResponseHandler(command));
            iter.remove();
            return;
        }
        throw new ProtocolException("No subscription matched.");
    }

    protected void onStompConnect(final StompFrame command) throws ProtocolException {
        if (this.connected.get()) {
            throw new ProtocolException("Allready connected.");
        }
        final Map<String, String> headers = command.getHeaders();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientId = headers.get("client-id");
        IntrospectionSupport.setProperties(this.connectionInfo, headers, "activemq.");
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null) {
            this.connectionInfo.setClientId(clientId);
        } else {
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(login);
        this.connectionInfo.setPassword(passcode);
        this.connectionInfo.setTransportContext(this.stompTransport.getPeerCertificates());
        this.sendToActiveMQ(this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    ProtocolConverter.this.handleException(exception, command);
                    ProtocolConverter.this.getStompTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(ProtocolConverter.this.sessionId);
                ProtocolConverter.this.sendToActiveMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(ProtocolConverter.this.producerId);
                ProtocolConverter.this.sendToActiveMQ(producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            ProtocolConverter.this.handleException(exception, command);
                            ProtocolConverter.this.getStompTransport().onException(IOExceptionSupport.create(exception));
                        }
                        ProtocolConverter.this.connected.set(true);
                        HashMap<String, String> responseHeaders = new HashMap<String, String>();
                        responseHeaders.put("session", ProtocolConverter.this.connectionInfo.getClientId());
                        String requestId = (String)headers.get("request-id");
                        if (requestId == null) {
                            requestId = (String)headers.get("receipt");
                        }
                        if (requestId != null) {
                            responseHeaders.put("response-id", requestId);
                            responseHeaders.put("receipt-id", requestId);
                        }
                        StompFrame sc = new StompFrame();
                        sc.setAction("CONNECTED");
                        sc.setHeaders(responseHeaders);
                        ProtocolConverter.this.sendToStomp(sc);
                    }
                });
            }
        });
    }

    protected void onStompDisconnect(StompFrame command) throws ProtocolException {
        this.checkConnected();
        this.sendToActiveMQ(this.connectionInfo.createRemoveCommand(), this.createResponseHandler(command));
        this.sendToActiveMQ(new ShutdownInfo(), this.createResponseHandler(command));
        this.connected.set(false);
    }

    protected void checkConnected() throws ProtocolException {
        if (!this.connected.get()) {
            throw new ProtocolException("Not connected.");
        }
    }

    public void onActiveMQCommand(Command command) throws IOException, JMSException {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            StompSubscription sub = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                sub.onMessageDispatch(md);
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        }
    }

    public ActiveMQMessage convertMessage(StompFrame command) throws IOException, JMSException {
        ActiveMQMessage msg = this.findTranslator(command.getHeaders().get("transformation")).convertFrame(this, command);
        return msg;
    }

    public StompFrame convertMessage(ActiveMQMessage message, boolean ignoreTransformation) throws IOException, JMSException {
        if (ignoreTransformation) {
            return this.frameTranslator.convertMessage(this, message);
        }
        return this.findTranslator(message.getStringProperty("transformation")).convertMessage(this, message);
    }

    public StompTransport getStompTransport() {
        return this.stompTransport;
    }

    public ActiveMQDestination createTempQueue(String name) {
        ActiveMQDestination rc = this.tempDestinations.get(name);
        if (rc == null) {
            rc = new ActiveMQTempQueue(this.connectionId, this.tempDestinationGenerator.getNextSequenceId());
            this.sendToActiveMQ(new DestinationInfo(this.connectionId, 0, rc), null);
            this.tempDestinations.put(name, rc);
        }
        return rc;
    }

    public ActiveMQDestination createTempTopic(String name) {
        ActiveMQDestination rc = this.tempDestinations.get(name);
        if (rc == null) {
            rc = new ActiveMQTempTopic(this.connectionId, this.tempDestinationGenerator.getNextSequenceId());
            this.sendToActiveMQ(new DestinationInfo(this.connectionId, 0, rc), null);
            this.tempDestinations.put(name, rc);
            this.tempDestinationAmqToStompMap.put(rc.getQualifiedName(), name);
        }
        return rc;
    }

    public String getCreatedTempDestinationName(ActiveMQDestination destination) {
        return this.tempDestinationAmqToStompMap.get(destination.getQualifiedName());
    }
}

