/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.kahadb.index.ListIndex;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.LinkedNode;
import org.apache.kahadb.util.LinkedNodeList;
import org.apache.kahadb.util.VariableMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListNode<Key, Value> {
    private static final boolean ADD_FIRST = true;
    private static final boolean ADD_LAST = false;
    private static final long NOT_SET = -1L;
    private final ListIndex<Key, Value> index;
    private Page<ListNode<Key, Value>> page;
    protected LinkedNodeList<KeyValueEntry<Key, Value>> entries = new LinkedNodeList();
    private long next = -1L;

    public int size(Transaction tx) {
        return this.entries.size();
    }

    public ListNode(ListIndex<Key, Value> index) {
        this.index = index;
    }

    private void doRemove(Transaction tx, ListNode current, ListNode prev, KeyValueEntry<Key, Value> entry) throws IOException {
        entry.unlink();
        if (current.entries.isEmpty()) {
            if (current.getPageId() == this.index.getHeadPageId()) {
                if (current.getNext() != -1L) {
                    this.index.setHeadPageId(current.getNext());
                    tx.free(current.getPageId());
                } else {
                    this.store(tx);
                }
            } else {
                prev.setNext(current.next);
                this.index.storeNode(tx, prev, false);
                tx.free(current.getPageId());
            }
        } else {
            this.store(tx);
        }
    }

    public Value put(Transaction tx, Key key, Value value) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.entries.addLast(new KeyValueEntry<Key, Value>(key, value));
        this.store(tx, false);
        return null;
    }

    public Value addFirst(Transaction tx, Key key, Value value) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.entries.addFirst(new KeyValueEntry<Key, Value>(key, value));
        this.store(tx, true);
        return null;
    }

    private void store(Transaction tx, boolean addFirst) throws IOException {
        try {
            this.index.storeNode(tx, this, false);
        }
        catch (Transaction.PageOverflowIOException e) {
            this.split(tx, addFirst);
        }
    }

    private void store(Transaction tx) throws IOException {
        this.index.storeNode(tx, this, false);
    }

    private void split(Transaction tx, boolean isAddFirst) throws IOException {
        ListNode<Key, Value> extension = this.index.createNode(tx);
        if (isAddFirst) {
            extension.setNext(this.getNext());
            this.setNext(extension.getPageId());
            super.setEntries(this.entries.getHead().splitAfter());
        } else {
            this.index.setTailPageId(extension.getPageId());
            this.setNext(extension.getPageId());
            super.setEntries(((KeyValueEntry)this.entries.getTail().getPrevious()).splitAfter());
        }
        this.index.storeNode(tx, this, false);
        super.store(tx, isAddFirst);
    }

    private void setEntries(LinkedNodeList<KeyValueEntry<Key, Value>> list) {
        this.entries = list;
    }

    public Value get(Transaction tx, Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Value result = null;
        for (KeyValueEntry nextEntry = this.entries.getTail(); nextEntry != null; nextEntry = (KeyValueEntry)nextEntry.getPrevious()) {
            if (!nextEntry.getKey().equals(key)) continue;
            result = nextEntry.getValue();
            break;
        }
        return result;
    }

    public boolean isEmpty(Transaction tx) throws IOException {
        return this.entries.isEmpty();
    }

    public Map.Entry<Key, Value> getFirst(Transaction tx) throws IOException {
        return this.entries.getHead();
    }

    public Map.Entry<Key, Value> getLast(Transaction tx) throws IOException {
        return this.entries.getTail();
    }

    public Iterator<Map.Entry<Key, Value>> iterator(Transaction tx, long pos) throws IOException {
        return new ListIterator(tx, this, pos);
    }

    public Iterator<Map.Entry<Key, Value>> iterator(Transaction tx) throws IOException {
        return new ListIterator(tx, this, 0L);
    }

    Iterator<ListNode<Key, Value>> listNodeIterator(Transaction tx) throws IOException {
        return new ListNodeIterator(tx, this);
    }

    public void clear(Transaction tx) throws IOException {
        this.entries.clear();
        tx.free(this.getPageId());
    }

    public boolean contains(Transaction tx, Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean found = false;
        for (KeyValueEntry nextEntry = this.entries.getTail(); nextEntry != null; nextEntry = (KeyValueEntry)nextEntry.getPrevious()) {
            if (!nextEntry.getKey().equals(key)) continue;
            found = true;
            break;
        }
        return found;
    }

    public long getPageId() {
        return this.page.getPageId();
    }

    public Page<ListNode<Key, Value>> getPage() {
        return this.page;
    }

    public void setPage(Page<ListNode<Key, Value>> page) {
        this.page = page;
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    public String toString() {
        return "[ListNode(" + this.page.getPageId() + "->" + this.next + ") " + this.entries.toString() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Marshaller<Key, Value>
    extends VariableMarshaller<ListNode<Key, Value>> {
        private final ListIndex<Key, Value> index;

        public Marshaller(ListIndex<Key, Value> index) {
            this.index = index;
        }

        @Override
        public void writePayload(ListNode<Key, Value> node, DataOutput os) throws IOException {
            os.writeLong(((ListNode)node).next);
            short count = (short)node.entries.size();
            if (count != node.entries.size()) {
                throw new IOException("short over flow, too many entries in list: " + node.entries.size());
            }
            os.writeShort(count);
            for (KeyValueEntry entry = node.entries.getHead(); entry != null; entry = (KeyValueEntry)entry.getNext()) {
                this.index.getKeyMarshaller().writePayload(entry.getKey(), os);
                this.index.getValueMarshaller().writePayload(entry.getValue(), os);
            }
        }

        @Override
        public ListNode<Key, Value> readPayload(DataInput is) throws IOException {
            ListNode<Key, Value> node = new ListNode<Key, Value>(this.index);
            ((ListNode)node).next = is.readLong();
            short size = is.readShort();
            for (short i = 0; i < size; i = (short)(i + 1)) {
                node.entries.addLast(new KeyValueEntry<Key, Value>(this.index.getKeyMarshaller().readPayload(is), this.index.getValueMarshaller().readPayload(is)));
            }
            return node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListIterator
    implements Iterator<Map.Entry<Key, Value>> {
        private final Transaction tx;
        ListNode<Key, Value> current;
        ListNode<Key, Value> prev;
        KeyValueEntry<Key, Value> nextEntry;
        KeyValueEntry<Key, Value> toRemove;

        private ListIterator(Transaction tx, ListNode<Key, Value> current, long nextIndex) throws IOException {
            this.tx = tx;
            this.current = current;
            this.nextEntry = current.entries.getHead();
            if (nextIndex > 0L && this.nextEntry != null) {
                for (long i = 0L; i < nextIndex; ++i) {
                    this.nextEntry = (KeyValueEntry)this.nextEntry.getNext();
                    if (this.nextEntry != null || this.nextFromNextListNode()) continue;
                    throw new NoSuchElementException("Index out of range: " + nextIndex);
                }
            }
        }

        private boolean nextFromNextListNode() {
            boolean haveNext = false;
            if (this.current.getNext() != -1L) {
                try {
                    this.prev = this.current;
                    this.current = ListNode.this.index.loadNode(this.tx, this.current.getNext());
                }
                catch (IOException unexpected) {
                    NoSuchElementException e = new NoSuchElementException(unexpected.getLocalizedMessage());
                    e.initCause(unexpected);
                    throw e;
                }
                this.nextEntry = this.current.entries.getHead();
                haveNext = this.nextEntry != null;
            }
            return haveNext;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null || this.nextFromNextListNode();
        }

        @Override
        public Map.Entry<Key, Value> next() {
            if (this.nextEntry != null) {
                this.toRemove = this.nextEntry;
                this.nextEntry = (KeyValueEntry)this.toRemove.getNext();
                return this.toRemove;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.toRemove == null) {
                throw new IllegalStateException("can only remove once, call next again");
            }
            try {
                ListNode.this.doRemove(this.tx, this.current, this.prev, this.toRemove);
                ListNode.this.index.onRemove();
                this.toRemove = null;
            }
            catch (IOException unexpected) {
                IllegalStateException e = new IllegalStateException(unexpected.getLocalizedMessage());
                e.initCause(unexpected);
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListNodeIterator
    implements Iterator<ListNode<Key, Value>> {
        private final Transaction tx;
        ListNode<Key, Value> nextEntry;

        private ListNodeIterator(Transaction tx, ListNode<Key, Value> current) throws IOException {
            this.tx = tx;
            this.nextEntry = current;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public ListNode<Key, Value> next() {
            ListNode current = this.nextEntry;
            if (this.nextEntry != null) {
                if (this.nextEntry.next != -1L) {
                    try {
                        this.nextEntry = ListNode.this.index.loadNode(this.tx, current.next);
                    }
                    catch (IOException unexpected) {
                        IllegalStateException e = new IllegalStateException("failed to load next: " + current.next + ", reason: " + unexpected.getLocalizedMessage());
                        e.initCause(unexpected);
                        throw e;
                    }
                } else {
                    this.nextEntry = null;
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class KeyValueEntry<Key, Value>
    extends LinkedNode<KeyValueEntry<Key, Value>>
    implements Map.Entry<Key, Value> {
        private final Key key;
        private final Value value;

        public KeyValueEntry(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "{" + this.key + ":" + this.value + "}";
        }
    }
}

