/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.command.Message;
import org.apache.activemq.state.ProducerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBrokerExchange {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerBrokerExchange.class);
    private ConnectionContext connectionContext;
    private Destination regionDestination;
    private Region region;
    private ProducerState producerState;
    private boolean mutable = true;
    private long lastSendSequenceNumber = -1L;

    public ProducerBrokerExchange copy() {
        ProducerBrokerExchange rc = new ProducerBrokerExchange();
        rc.connectionContext = this.connectionContext.copy();
        rc.regionDestination = this.regionDestination;
        rc.region = this.region;
        rc.producerState = this.producerState;
        rc.mutable = this.mutable;
        return rc;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public Destination getRegionDestination() {
        return this.regionDestination;
    }

    public void setRegionDestination(Destination regionDestination) {
        this.regionDestination = regionDestination;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public ProducerState getProducerState() {
        return this.producerState;
    }

    public void setProducerState(ProducerState producerState) {
        this.producerState = producerState;
    }

    public boolean canDispatch(Message messageSend) {
        boolean canDispatch = true;
        if (this.lastSendSequenceNumber > 0L && messageSend.getMessageId().getProducerSequenceId() <= this.lastSendSequenceNumber) {
            canDispatch = false;
            LOG.debug("suppressing duplicate message send [" + messageSend.getMessageId() + "] with producerSequenceId [" + messageSend.getMessageId().getProducerSequenceId() + "] less than last stored: " + this.lastSendSequenceNumber);
        }
        return canDispatch;
    }

    public void setLastStoredSequenceId(long l) {
        this.lastSendSequenceNumber = l;
        LOG.debug("last stored sequence id set: " + l);
    }
}

